/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.storage.core.handler.biz;

import com.sinosoftgz.starter.captcha.storage.core.enums.CaptchaStorageType;
import com.sinosoftgz.starter.captcha.storage.core.handler.annotation.CaptchaStorageHandlerType;
import com.sinosoftgz.starter.captcha.storage.core.handler.biz.DefaultCaptchaStorageHandler;
import com.sinosoftgz.starter.captcha.storage.db.service.ICaptchaStorageService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@CaptchaStorageHandlerType(value=CaptchaStorageType.db)
public class DbCaptchaStorageHandler
extends DefaultCaptchaStorageHandler {
    private static final Logger log = LoggerFactory.getLogger(DbCaptchaStorageHandler.class);
    @Resource
    ICaptchaStorageService iCaptchaStorageService;

    public void set(String key, String value, long expiresInSeconds) {
        this.checkKey(key);
        key = this.generatorKey(key);
        this.iCaptchaStorageService.set(key, value, expiresInSeconds);
    }

    public boolean exists(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        return this.iCaptchaStorageService.hasKey(key);
    }

    public void delete(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        this.iCaptchaStorageService.delete(key);
    }

    public String get(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        return (String)this.iCaptchaStorageService.get(key);
    }

    public Long increment(String key, long val) {
        this.checkKey(key);
        Long ret = Long.valueOf((String)this.iCaptchaStorageService.get(key)) + val;
        this.iCaptchaStorageService.set(key, ret + "", 0L);
        return ret;
    }
}

