/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.storage.db.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.starter.captcha.storage.db.entity.CaptchaStorage;
import com.sinosoftgz.starter.captcha.storage.db.mapper.CaptchaStorageMapper;
import com.sinosoftgz.starter.captcha.storage.db.service.ICaptchaStorageService;
import java.util.Objects;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CaptchaStorageServiceImpl
extends ServiceImpl<CaptchaStorageMapper, CaptchaStorage>
implements ICaptchaStorageService {
    public static final Integer KEY_MAX_LENGTH = 512;

    @Override
    public void set(String key, String value, long expiresInSeconds) {
        this.checkKey(key);
        CaptchaStorage captchaStorage = this.query(key);
        if (Objects.isNull((Object)captchaStorage)) {
            captchaStorage = new CaptchaStorage();
            captchaStorage.setCaptchaId(key);
        }
        DateTime now = new DateTime();
        now = now.plusMillis(new Long(expiresInSeconds).intValue());
        captchaStorage.setCaptchaCode(value);
        captchaStorage.setCaptchaExpirationDate(now.toDate());
        this.saveOrUpdate((Object)captchaStorage);
    }

    @Override
    public boolean hasKey(String key) {
        this.checkKey(key);
        CaptchaStorage captchaStorage = this.query(key);
        return !Objects.isNull((Object)captchaStorage);
    }

    @Override
    public void delete(String key) {
        this.checkKey(key);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"captcha_id", (Object)key);
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public Object get(String key) {
        this.checkKey(key);
        CaptchaStorage captchaStorage = this.query(key);
        if (!Objects.isNull((Object)captchaStorage)) {
            return captchaStorage.getCaptchaCode();
        }
        return null;
    }

    private CaptchaStorage query(String key) {
        this.checkKey(key);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"captcha_id", (Object)key);
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.ge((Object)"captcha_expiration_date", (Object)new DateTime().toDate());
        CaptchaStorage captchaStorage = (CaptchaStorage)((Object)this.getOne((Wrapper)queryWrapper));
        return captchaStorage;
    }

    private void checkKey(String key) {
        Assert.notNull((Object)key, (String)String.format("%s must be have value!", "key"));
        Assert.isTrue((key.length() <= KEY_MAX_LENGTH ? 1 : 0) != 0, (String)("key\u6700\u5927\u503c\u53ea\u80fd\u662f:" + KEY_MAX_LENGTH));
    }
}

