package com.sinosoftgz.starter.captcha.storage.core.handler.biz;

import com.sinosoftgz.starter.captcha.storage.core.enums.CaptchaStorageType;
import com.sinosoftgz.starter.captcha.storage.core.handler.annotation.CaptchaStorageHandlerType;
import com.sinosoftgz.starter.redis.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * @author: Roney
 * @date: 2022-06-10 15:42
 * @description: 验证码存储Redis实现
 */
@Component
@CaptchaStorageHandlerType(CaptchaStorageType.redis)
@Slf4j
public class RedisCaptchaStorageHandler extends DefaultCaptchaStorageHandler {

    @Resource
    RedisUtils redisUtils;

    @Override
    public void set(String key, String value, long expiresInSeconds) {
        checkKey(key);
        key = generatorKey(key);
        redisUtils.set(key, value, expiresInSeconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean exists(String key) {
        checkKey(key);
        key = generatorKey(key);
        return redisUtils.hasKey(key);
    }

    @Override
    public void delete(String key) {
        checkKey(key);
        key = generatorKey(key);
        redisUtils.delete(key);
    }

    @Override
    public String get(String key) {
        checkKey(key);
        key = generatorKey(key);
        return (String) redisUtils.get(key);
    }

    @Override
    public Long increment(String key, long val) {
        checkKey(key);
        Long ret = Long.valueOf((String) redisUtils.get(key)) + val;
        redisUtils.set(key, ret + "", 0);
        return ret;
    }
}
