/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.storage.core.handler.biz;

import com.sinosoftgz.starter.captcha.storage.core.enums.CaptchaStorageType;
import com.sinosoftgz.starter.captcha.storage.core.handler.annotation.CaptchaStorageHandlerType;
import com.sinosoftgz.starter.captcha.storage.core.handler.biz.DefaultCaptchaStorageHandler;
import com.sinosoftgz.starter.redis.utils.RedisUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@CaptchaStorageHandlerType(value=CaptchaStorageType.redis)
public class RedisCaptchaStorageHandler
extends DefaultCaptchaStorageHandler {
    private static final Logger log = LoggerFactory.getLogger(RedisCaptchaStorageHandler.class);
    @Resource
    RedisUtils redisUtils;

    public void set(String key, String value, long expiresInSeconds) {
        this.checkKey(key);
        key = this.generatorKey(key);
        this.redisUtils.set(key, (Object)value, expiresInSeconds, TimeUnit.MILLISECONDS);
    }

    public boolean exists(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        return this.redisUtils.hasKey(key);
    }

    public void delete(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        this.redisUtils.delete(new String[]{key});
    }

    public String get(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        return (String)this.redisUtils.get(key);
    }

    public Long increment(String key, long val) {
        this.checkKey(key);
        Long ret = Long.valueOf((String)this.redisUtils.get(key)) + val;
        this.redisUtils.set(key, (Object)(ret + ""), 0L);
        return ret;
    }
}

