package com.sinosoftgz.starter.captcha.storage.core.handler.biz;

import com.sinosoftgz.starter.captcha.storage.core.enums.CaptchaStorageType;
import com.sinosoftgz.starter.captcha.storage.core.handler.annotation.CaptchaStorageHandlerType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author: Roney
 * @date: 2022-06-10 15:42
 * @description: 验证码存储Session实现
 */
@Component
@CaptchaStorageHandlerType(CaptchaStorageType.session)
@Slf4j
public class SessionCaptchaStorageHandler extends DefaultCaptchaStorageHandler {

    @Resource
    public HttpServletRequest request;

    @Override
    public void set(String key, String value, long expiresInSeconds) {
        checkKey(key);
        key = generatorKey(key);
        request.getSession().setAttribute(key, value);
    }

    @Override
    public boolean exists(String key) {
        checkKey(key);
        if (StringUtils.hasLength(get(key))) {
            return true;
        }
        return false;
    }

    @Override
    public void delete(String key) {
        checkKey(key);
        key = generatorKey(key);
        request.getSession().removeAttribute(key);
    }

    @Override
    public String get(String key) {
        checkKey(key);
        key = generatorKey(key);
        return (String) request.getSession().getAttribute(key);
    }

    @Override
    public Long increment(String key, long val) {
        checkKey(key);
        Long ret = Long.valueOf((String) request.getSession().getAttribute(key)) + val;
        request.getSession().setAttribute(key, ret + "");
        return ret;
    }
}
