/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.storage.core.handler.biz;

import com.sinosoftgz.starter.captcha.storage.core.enums.CaptchaStorageType;
import com.sinosoftgz.starter.captcha.storage.core.handler.annotation.CaptchaStorageHandlerType;
import com.sinosoftgz.starter.captcha.storage.core.handler.biz.DefaultCaptchaStorageHandler;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@CaptchaStorageHandlerType(value=CaptchaStorageType.session)
public class SessionCaptchaStorageHandler
extends DefaultCaptchaStorageHandler {
    private static final Logger log = LoggerFactory.getLogger(SessionCaptchaStorageHandler.class);
    @Resource
    public HttpServletRequest request;

    public void set(String key, String value, long expiresInSeconds) {
        this.checkKey(key);
        key = this.generatorKey(key);
        this.request.getSession().setAttribute(key, (Object)value);
    }

    public boolean exists(String key) {
        this.checkKey(key);
        return StringUtils.hasLength((String)this.get(key));
    }

    public void delete(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        this.request.getSession().removeAttribute(key);
    }

    public String get(String key) {
        this.checkKey(key);
        key = this.generatorKey(key);
        return (String)this.request.getSession().getAttribute(key);
    }

    public Long increment(String key, long val) {
        this.checkKey(key);
        Long ret = Long.valueOf((String)this.request.getSession().getAttribute(key)) + val;
        this.request.getSession().setAttribute(key, (Object)(ret + ""));
        return ret;
    }
}

