/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.platform.weworkapi.api.JsapiTicketApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.wework.JsapiTicket;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class BaseJsapiTicketApi
implements JsapiTicketApi {
    private WeworkAppProperties weworkProperties;
    private HttpHelper httpHelper;
    private UriTemplateHelper uriTemplateHelper;

    public BaseJsapiTicketApi(WeworkAppProperties weworkProperties, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.weworkProperties = weworkProperties;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    @Override
    public BaseResponse<JsapiTicket> getCorp(String accessToken) throws ApiInvokeException {
        AtomicInteger retryCount = new AtomicInteger(1);
        Boolean retryFlag = true;
        BaseResponse<JsapiTicket> response = null;
        while (retryFlag.booleanValue() && retryCount.get() <= this.weworkProperties.getApi().getMaxTry()) {
            response = this.get(accessToken, "");
            if (Constant.WeworkApiErrors.SERVER_BUSY.equals(response.getErrcode())) {
                retryFlag = true;
                retryCount.addAndGet(1);
                continue;
            }
            retryFlag = false;
        }
        return response;
    }

    @Override
    public BaseResponse<JsapiTicket> getApp(String accessToken) throws ApiInvokeException {
        AtomicInteger retryCount = new AtomicInteger(1);
        Boolean retryFlag = true;
        BaseResponse<JsapiTicket> response = null;
        while (retryFlag.booleanValue() && retryCount.get() <= this.weworkProperties.getApi().getMaxTry()) {
            response = this.get(accessToken, "agent_config");
            if (Constant.WeworkApiErrors.SERVER_BUSY.equals(response.getErrcode())) {
                retryFlag = true;
                retryCount.addAndGet(1);
                continue;
            }
            retryFlag = false;
        }
        return response;
    }

    protected BaseResponse<JsapiTicket> get(final String accessToken, final String type) throws ApiInvokeException {
        BaseResponse<JsapiTicket> baseResponse = new BaseResponse<JsapiTicket>();
        String uri = type != null && "agent_config".equals(type) ? this.uriTemplateHelper.render(this.weworkProperties.getApi().getGetTicketApiPath(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ACCESS_TOKEN", accessToken);
                this.put("TYPE", type);
            }
        }) : this.uriTemplateHelper.render(this.weworkProperties.getApi().getGetJsapiTicketApiPath(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ACCESS_TOKEN", accessToken);
                this.put("TYPE", type);
            }
        });
        try {
            Optional<String> result = this.httpHelper.get(this.weworkProperties.getApi().getBaseUrl() + uri);
            if (result.isPresent()) {
                JSONObject jsonObject = JSON.parseObject((String)result.get());
                Date refreshTime = new Date();
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(jsonObject.getString("errcode"))) {
                    JsapiTicket jsapiTicket = (JsapiTicket)JSON.parseObject((String)result.get(), JsapiTicket.class);
                    baseResponse.setSuccess(true);
                    baseResponse.setData(jsapiTicket);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(jsonObject.getString("errcode"));
                    baseResponse.setErrmsg(jsonObject.getString("errmsg"));
                }
            }
        }
        catch (IOException e) {
            throw new ApiInvokeException(Constant.ApiInvokeErrors.NETWORK_ERROR, (Throwable)e);
        }
        catch (JSONException je) {
            throw new ApiInvokeException(Constant.ApiInvokeErrors.RESPONSE_PARSE_ERROR, (Throwable)je);
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<JsapiTicket> refreshCorp(String accessToken) throws ApiInvokeException {
        return this.getCorp(accessToken);
    }

    @Override
    public BaseResponse<JsapiTicket> refreshApp(String accessToken) throws ApiInvokeException {
        return this.getApp(accessToken);
    }
}

