/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkAccessToken;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class BasicAccessTokenApi
implements AccessTokenApi {
    private static final String CACHE_KEY_TEMPLATE_ACCESSTOKEN = "wework:cache:accesstoken:%s_TOKEN";
    private static final String CACHE_KEY_TEMPLATE_ACCESSTOKEN_REFRESH_TIME = "wework:cache:accesstoken:%s_LASTREFRESHED";
    private static final String CACHE_KEY_TEMPLATE_ACCESSTOKEN_EXPIRES = "wework:cache:accesstoken:%s_EXPIRES";
    private WeworkAppProperties weworkProperties;
    private HttpHelper httpHelper;
    private UriTemplateHelper uriTemplateHelper;

    protected BasicAccessTokenApi() {
    }

    public BasicAccessTokenApi(WeworkAppProperties weworkProperties, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.weworkProperties = weworkProperties;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    @Override
    public BaseResponse<WeworkAccessToken> get(WeworkAppProperties properties) throws ApiInvokeException {
        return this.get(properties.getCorpId(), properties.getAppSecret());
    }

    @Override
    public BaseResponse<WeworkAccessToken> get(String corpid, String secret) throws ApiInvokeException {
        AtomicInteger retryCount = new AtomicInteger(1);
        Boolean retryFlag = true;
        BaseResponse<WeworkAccessToken> response = null;
        while (retryFlag.booleanValue() && retryCount.get() <= this.weworkProperties.getApi().getMaxTry()) {
            response = this.get(corpid, secret, true);
            if (Constant.WeworkApiErrors.SERVER_BUSY.equals(response.getErrcode())) {
                retryFlag = true;
                retryCount.addAndGet(1);
                continue;
            }
            retryFlag = false;
        }
        return response;
    }

    @Override
    public BaseResponse<WeworkAccessToken> refresh(String corpid, String secret) throws ApiInvokeException {
        AtomicInteger retryCount = new AtomicInteger(1);
        Boolean retryFlag = true;
        BaseResponse<WeworkAccessToken> response = null;
        while (retryFlag.booleanValue() && retryCount.get() <= this.weworkProperties.getApi().getMaxTry()) {
            response = this.get(corpid, secret, false);
            if (Constant.WeworkApiErrors.SERVER_BUSY.equals(response.getErrcode())) {
                retryFlag = true;
                retryCount.addAndGet(1);
                continue;
            }
            retryFlag = false;
        }
        return response;
    }

    private BaseResponse<WeworkAccessToken> get(final String corpid, final String secret, Boolean cached) throws ApiInvokeException {
        BaseResponse<WeworkAccessToken> baseResponse = new BaseResponse<WeworkAccessToken>();
        String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getGettokenApiPath(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("CORPID", corpid);
                this.put("SECRECT", secret);
            }
        });
        try {
            Optional<String> result = this.httpHelper.get(this.weworkProperties.getApi().getBaseUrl() + uri);
            if (result.isPresent()) {
                JSONObject jsonObject = JSON.parseObject((String)result.get());
                Date refreshTime = new Date();
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(jsonObject.getString("errcode"))) {
                    WeworkAccessToken accessToken = (WeworkAccessToken)JSON.parseObject((String)result.get(), WeworkAccessToken.class);
                    baseResponse.setSuccess(true);
                    baseResponse.setData(accessToken);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(jsonObject.getString("errcode"));
                    baseResponse.setErrmsg(jsonObject.getString("errmsg"));
                }
            }
        }
        catch (IOException e) {
            throw new ApiInvokeException(Constant.ApiInvokeErrors.NETWORK_ERROR, (Throwable)e);
        }
        catch (JSONException je) {
            throw new ApiInvokeException(Constant.ApiInvokeErrors.RESPONSE_PARSE_ERROR, (Throwable)je);
        }
        return baseResponse;
    }

    public WeworkAppProperties getWeworkProperties() {
        return this.weworkProperties;
    }

    public HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    public UriTemplateHelper getUriTemplateHelper() {
        return this.uriTemplateHelper;
    }

    public void setWeworkProperties(WeworkAppProperties weworkProperties) {
        this.weworkProperties = weworkProperties;
    }

    public void setHttpHelper(HttpHelper httpHelper) {
        this.httpHelper = httpHelper;
    }

    public void setUriTemplateHelper(UriTemplateHelper uriTemplateHelper) {
        this.uriTemplateHelper = uriTemplateHelper;
    }
}

