/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.CorpUserApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.response.BaseWeworkResponse;
import com.picc.gz.platform.weworkapi.vo.response.OpenIdWeworkResponse;
import com.picc.gz.platform.weworkapi.vo.response.UserIdWeworkResponse;
import com.picc.gz.platform.weworkapi.vo.response.WeworkUserResponse;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkAccessToken;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkDepartment;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkUser;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkUserSimple;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;

public class BasicCorpUserApi
implements CorpUserApi {
    private WeworkAppProperties weworkProperties;
    private AccessTokenApi accessTokenApi;
    private HttpHelper httpHelper;
    private UriTemplateHelper uriTemplateHelper;

    private BasicCorpUserApi() {
    }

    public BasicCorpUserApi(WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.weworkProperties = weworkProperties;
        this.accessTokenApi = accessTokenApi;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    @Override
    public BaseWeworkResponse userCreate(WeworkUser WeworkUser2) {
        return null;
    }

    @Override
    public BaseResponse<WeworkUser> userGet(String userid) throws ApiInvokeException, IOException {
        BaseResponse<WeworkUser> baseResponse = new BaseResponse<WeworkUser>();
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            params.put("USERID", userid);
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getUsergetApiPath(), params);
            Optional<WeworkUserResponse> result = this.httpHelper.getJSON(this.weworkProperties.getApi().getBaseUrl() + uri, null, WeworkUserResponse.class);
            if (result.isPresent()) {
                String errorCode = result.get().getErrcode();
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(errorCode)) {
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    WeworkUser weworkUser = new WeworkUser();
                    BeanUtils.copyProperties((Object)result.get(), (Object)weworkUser);
                    baseResponse.setData(weworkUser);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(result.get().getErrcode());
                    baseResponse.setErrmsg(result.get().getErrmsg());
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        }
        return baseResponse;
    }

    @Override
    public BaseWeworkResponse userUpdate(WeworkUser user) {
        return null;
    }

    @Override
    public BaseWeworkResponse userDelete(String userid) {
        return null;
    }

    @Override
    public BaseWeworkResponse userBatchDelete(List<String> useridList) {
        return null;
    }

    @Override
    public BaseResponse<List<WeworkUserSimple>> userSimpleList(String departmentId, Boolean fetchChild) throws ApiInvokeException, IOException {
        BaseResponse<List<WeworkUserSimple>> baseResponse = new BaseResponse<List<WeworkUserSimple>>();
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            params.put("DEPARTMENT_ID", departmentId == null ? "" : departmentId);
            params.put("FETCH_CHILD", fetchChild == null ? "" : (fetchChild != false ? "1" : "0"));
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getUserSimplelistApiPath(), params);
            Optional<String> result = this.httpHelper.get(this.weworkProperties.getApi().getBaseUrl() + uri);
            if (result.isPresent()) {
                JSONObject jsonObject = JSON.parseObject((String)result.get());
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(jsonObject.getString("errcode"))) {
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    List users = jsonObject.getJSONArray("department").toJavaList(WeworkUserSimple.class);
                    baseResponse.setData(users);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(jsonObject.getString("errcode"));
                    baseResponse.setErrmsg(jsonObject.getString("errmsg"));
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<List<WeworkUser>> userList(String departmentId, Boolean fetchChild) throws ApiInvokeException, IOException {
        BaseResponse<List<WeworkUser>> baseResponse = new BaseResponse<List<WeworkUser>>();
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            params.put("DEPARTMENT_ID", departmentId == null ? "" : departmentId);
            params.put("FETCH_CHILD", fetchChild == null ? "" : (fetchChild != false ? "1" : "0"));
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getUserSimplelistApiPath(), params);
            Optional<String> result = this.httpHelper.get(this.weworkProperties.getApi().getBaseUrl() + uri);
            if (result.isPresent()) {
                JSONObject jsonObject = JSON.parseObject((String)result.get());
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(jsonObject.getString("errcode"))) {
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    List users = jsonObject.getJSONArray("userlist").toJavaList(WeworkUser.class);
                    baseResponse.setData(users);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(jsonObject.getString("errcode"));
                    baseResponse.setErrmsg(jsonObject.getString("errmsg"));
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        }
        return baseResponse;
    }

    @Override
    public OpenIdWeworkResponse userId2OpenId(String userid) {
        return null;
    }

    @Override
    public BaseResponse<String> openId2UserId(String openId) throws ApiInvokeException, IOException {
        BaseResponse<String> baseResponse = new BaseResponse<String>();
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getOpenId2userIdApiPath(), params);
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("openid", openId);
            Optional<UserIdWeworkResponse> result = this.httpHelper.postJSON(this.weworkProperties.getApi().getBaseUrl() + uri, postData, UserIdWeworkResponse.class);
            if (result.isPresent()) {
                String errorCode = result.get().getErrcode();
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(errorCode)) {
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    String userId = result.get().getUserId();
                    baseResponse.setData(userId);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(result.get().getErrcode());
                    baseResponse.setErrmsg(result.get().getErrmsg());
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        }
        return baseResponse;
    }

    @Override
    public BaseWeworkResponse userAuthSuccess(String userid) {
        return null;
    }

    @Override
    public BaseResponse<List<WeworkDepartment>> listDepartments(String id) throws ApiInvokeException, IOException {
        BaseResponse<List<WeworkDepartment>> baseResponse = new BaseResponse<List<WeworkDepartment>>();
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            params.put("ID", id == null ? "" : id);
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getDepartmentListApiPath(), params);
            Optional<String> result = this.httpHelper.get(this.weworkProperties.getApi().getBaseUrl() + uri);
            if (result.isPresent()) {
                JSONObject jsonObject = JSON.parseObject((String)result.get());
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(jsonObject.getString("errcode"))) {
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    List departments = jsonObject.getJSONArray("department").toJavaList(WeworkDepartment.class);
                    baseResponse.setData(departments);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(jsonObject.getString("errcode"));
                    baseResponse.setErrmsg(jsonObject.getString("errmsg"));
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        }
        return baseResponse;
    }

    public WeworkAppProperties getWeworkProperties() {
        return this.weworkProperties;
    }

    public AccessTokenApi getAccessTokenApi() {
        return this.accessTokenApi;
    }

    public HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    public UriTemplateHelper getUriTemplateHelper() {
        return this.uriTemplateHelper;
    }

    public void setWeworkProperties(WeworkAppProperties weworkProperties) {
        this.weworkProperties = weworkProperties;
    }

    public void setAccessTokenApi(AccessTokenApi accessTokenApi) {
        this.accessTokenApi = accessTokenApi;
    }

    public void setHttpHelper(HttpHelper httpHelper) {
        this.httpHelper = httpHelper;
    }

    public void setUriTemplateHelper(UriTemplateHelper uriTemplateHelper) {
        this.uriTemplateHelper = uriTemplateHelper;
    }
}

