/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.MessageApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.message.request.MessageBase;
import com.picc.gz.platform.weworkapi.vo.message.response.MessageSendResp;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.response.MessageSendWeworkResponse;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkAccessToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class BasicMessageApi
implements MessageApi {
    private static final String WEWORK_SPLITER = "|";
    private RedisTemplate redisTemplate;
    private WeworkAppProperties weworkProperties;
    private AccessTokenApi accessTokenApi;
    private HttpHelper httpHelper;
    private UriTemplateHelper uriTemplateHelper;

    public BasicMessageApi(RedisTemplate redisTemplate, WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.redisTemplate = redisTemplate;
        this.weworkProperties = weworkProperties;
        this.accessTokenApi = accessTokenApi;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    public BasicMessageApi(WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.weworkProperties = weworkProperties;
        this.accessTokenApi = accessTokenApi;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    @Override
    public BaseResponse<MessageSendResp> send(MessageBase message) throws ApiInvokeException, IOException {
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        BaseResponse<MessageSendResp> baseResponse = new BaseResponse<MessageSendResp>();
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            if (message.getAgentid() <= 0) {
                message.setAgentid(Integer.parseInt(this.weworkProperties.getAppId()));
            }
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getMessageSendApiPath(), params);
            Optional<MessageSendWeworkResponse> result = this.httpHelper.postJSON(this.weworkProperties.getApi().getBaseUrl() + uri, message, MessageSendWeworkResponse.class);
            if (result.isPresent()) {
                MessageSendWeworkResponse weworkResponse = result.get();
                String errorCode = weworkResponse.getErrcode();
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(errorCode)) {
                    MessageSendResp respData = new MessageSendResp();
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    if (!StringUtils.isEmpty((Object)weworkResponse.getInvaliduser())) {
                        respData.setInvaliduser(Arrays.asList(weworkResponse.getInvaliduser().split(WEWORK_SPLITER)));
                    }
                    if (!StringUtils.isEmpty((Object)weworkResponse.getInvalidparty())) {
                        respData.setInvalidparty(Arrays.asList(weworkResponse.getInvalidparty().split(WEWORK_SPLITER)));
                    }
                    if (!StringUtils.isEmpty((Object)weworkResponse.getInvalidtag())) {
                        respData.setInvalidtag(Arrays.asList(weworkResponse.getInvalidtag().split(WEWORK_SPLITER)));
                    }
                    baseResponse.setData(respData);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(result.get().getErrcode());
                    baseResponse.setErrmsg(result.get().getErrmsg());
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        } else {
            baseResponse.setSuccess(false);
            baseResponse.setErrcode(tokenResponse.getErrcode());
            baseResponse.setErrmsg(tokenResponse.getErrmsg());
        }
        return baseResponse;
    }
}

