/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.OauthApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.response.UserInfo;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkAccessToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.data.redis.core.RedisTemplate;

public class BasicOauthApi
implements OauthApi {
    private RedisTemplate redisTemplate;
    private WeworkAppProperties weworkProperties;
    private AccessTokenApi accessTokenApi;
    private HttpHelper httpHelper;
    private UriTemplateHelper uriTemplateHelper;

    public BasicOauthApi(RedisTemplate redisTemplate, WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.redisTemplate = redisTemplate;
        this.weworkProperties = weworkProperties;
        this.accessTokenApi = accessTokenApi;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    public BasicOauthApi(WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        this.weworkProperties = weworkProperties;
        this.accessTokenApi = accessTokenApi;
        this.httpHelper = httpHelper;
        this.uriTemplateHelper = uriTemplateHelper;
    }

    @Override
    public BaseResponse<UserInfo> getuserinfo(String code) throws ApiInvokeException, IOException {
        BaseResponse<UserInfo> baseResponse = new BaseResponse<UserInfo>();
        BaseResponse<WeworkAccessToken> tokenResponse = this.accessTokenApi.get(this.weworkProperties);
        UserInfo userInfo = null;
        if (tokenResponse.isSuccess().booleanValue()) {
            WeworkAccessToken accessToken = tokenResponse.getData();
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("ACCESS_TOKEN", accessToken.getAccessToken());
            params.put("CODE", code == null ? "" : code);
            String uri = this.uriTemplateHelper.render(this.weworkProperties.getApi().getUserinfoApiPath(), params);
            Optional<String> result = this.httpHelper.get(this.weworkProperties.getApi().getBaseUrl() + uri);
            if (result.isPresent()) {
                JSONObject jsonObject = JSON.parseObject((String)result.get());
                if (Constant.WeworkApiErrors.SUCCESS.getValue().equals(jsonObject.getString("errcode"))) {
                    baseResponse.setSuccess(true);
                    baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                    userInfo = new UserInfo();
                    userInfo.setUserId(jsonObject.getString("UserId"));
                    userInfo.setOpenId(jsonObject.getString("OpenId"));
                    userInfo.setDeviceId(jsonObject.getString("DeviceId"));
                    baseResponse.setData(userInfo);
                } else {
                    baseResponse.setSuccess(false);
                    baseResponse.setErrcode(jsonObject.getString("errcode"));
                    baseResponse.setErrmsg(jsonObject.getString("errmsg"));
                }
            } else {
                baseResponse.setSuccess(false);
                baseResponse.setErrcode("9999");
                baseResponse.setErrmsg("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
        }
        return baseResponse;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public WeworkAppProperties getWeworkProperties() {
        return this.weworkProperties;
    }

    public AccessTokenApi getAccessTokenApi() {
        return this.accessTokenApi;
    }

    public HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    public UriTemplateHelper getUriTemplateHelper() {
        return this.uriTemplateHelper;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setWeworkProperties(WeworkAppProperties weworkProperties) {
        this.weworkProperties = weworkProperties;
    }

    public void setAccessTokenApi(AccessTokenApi accessTokenApi) {
        this.accessTokenApi = accessTokenApi;
    }

    public void setHttpHelper(HttpHelper httpHelper) {
        this.httpHelper = httpHelper;
    }

    public void setUriTemplateHelper(UriTemplateHelper uriTemplateHelper) {
        this.uriTemplateHelper = uriTemplateHelper;
    }
}

