/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.impl.BasicAccessTokenApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkAccessToken;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCachedAccessTokenApi
extends BasicAccessTokenApi
implements AccessTokenApi {
    private static final String CACHE_KEY_TEMPLATE_ACCESSTOKEN = "wework:cache:accesstoken:%s_TOKEN";
    private static final String CACHE_KEY_TEMPLATE_ACCESSTOKEN_REFRESH_TIME = "wework:cache:accesstoken:%s_LASTREFRESHED";
    private static final String CACHE_KEY_TEMPLATE_ACCESSTOKEN_EXPIRES = "wework:cache:accesstoken:%s_EXPIRES";
    private RedisTemplate redisTemplate;

    public RedisCachedAccessTokenApi(RedisTemplate redisTemplate, WeworkAppProperties weworkProperties, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        super(weworkProperties, httpHelper, uriTemplateHelper);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public BaseResponse<WeworkAccessToken> get(WeworkAppProperties properties) throws ApiInvokeException {
        return this.get(properties.getCorpId(), properties.getAppSecret());
    }

    private BaseResponse<WeworkAccessToken> get(String corpid, String secret, Boolean cached) throws ApiInvokeException {
        Date lastRefreshTime;
        String key = String.format("%s_%s", corpid, secret);
        BoundValueOperations tokenExpriesOpts = this.redisTemplate.boundValueOps((Object)String.format(CACHE_KEY_TEMPLATE_ACCESSTOKEN_EXPIRES, key));
        BoundValueOperations tokenLastRefreshOpts = this.redisTemplate.boundValueOps((Object)String.format(CACHE_KEY_TEMPLATE_ACCESSTOKEN_REFRESH_TIME, key));
        BoundValueOperations tokenOpts = this.redisTemplate.boundValueOps((Object)String.format(CACHE_KEY_TEMPLATE_ACCESSTOKEN, key));
        BaseResponse<WeworkAccessToken> baseResponse = null;
        if (cached.booleanValue() && (lastRefreshTime = (Date)tokenLastRefreshOpts.get()) != null) {
            Long expries = (Long)tokenExpriesOpts.get();
            expries = expries == null ? (long)this.getWeworkProperties().getApi().getTokenExpires().intValue() : expries;
            Calendar cLastRefreshed = Calendar.getInstance();
            cLastRefreshed.setTime(lastRefreshTime);
            cLastRefreshed.add(13, expries.intValue());
            if (cLastRefreshed.compareTo(Calendar.getInstance()) >= 0) {
                tokenExpriesOpts.expire(expries.longValue(), TimeUnit.SECONDS);
                tokenExpriesOpts.set((Object)expries);
                WeworkAccessToken weworkAccessToken = new WeworkAccessToken();
                weworkAccessToken.setAccessToken((String)tokenOpts.get());
                weworkAccessToken.setExpiresIn(new Long(expries));
                weworkAccessToken.setLastRefreshed((Date)tokenLastRefreshOpts.get());
                baseResponse = new BaseResponse();
                baseResponse.setSuccess(true);
                baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                baseResponse.setData(weworkAccessToken);
            }
        }
        if ((baseResponse == null || baseResponse.getData() == null || ((WeworkAccessToken)baseResponse.getData()).getAccessToken() == null) && (baseResponse = super.get(corpid, secret)).getSuccess().booleanValue()) {
            Date refreshTime = new Date();
            WeworkAccessToken accessToken = baseResponse.getData();
            tokenOpts.set((Object)accessToken.getAccessToken(), accessToken.getExpiresIn().longValue(), TimeUnit.SECONDS);
            tokenExpriesOpts.set((Object)accessToken.getExpiresIn(), accessToken.getExpiresIn().longValue(), TimeUnit.SECONDS);
            tokenLastRefreshOpts.set((Object)refreshTime, accessToken.getExpiresIn().longValue(), TimeUnit.SECONDS);
        }
        return baseResponse;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

