/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.CorpUserApi;
import com.picc.gz.platform.weworkapi.api.impl.BasicCorpUserApi;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.response.BaseWeworkResponse;
import com.picc.gz.platform.weworkapi.vo.response.OpenIdWeworkResponse;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkDepartment;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkUser;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkUserSimple;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisCachedCorpUserApi
extends BasicCorpUserApi
implements CorpUserApi {
    public static final String CACHE_KEY_PREFIX_DEPARTMENTLIST = "wework:api:cache:data:departmentlist:";
    public static final String CACHE_KEY_PREFIX_USERSIMPLELIST = "wework:api:cache:data:usersimplelist:";
    public static final String CACHE_KEY_PREFIX_USERLIST = "wework:api:cache:data:userlist:";
    public static final String CACHE_KEY_PREFIX_OPENID2USERID = "wework:api:cache:data:openid2userid:";
    public static final String CACHE_KEY_PREFIX_GETUSER = "wework:api:cache:data:getuser:";
    private RedisTemplate redisTemplate;

    public RedisCachedCorpUserApi(RedisTemplate redisTemplate, WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        super(weworkProperties, accessTokenApi, httpHelper, uriTemplateHelper);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public BaseWeworkResponse userCreate(WeworkUser WeworkUser2) {
        return null;
    }

    @Override
    public BaseResponse<WeworkUser> userGet(String userid) throws ApiInvokeException, IOException {
        BaseResponse<WeworkUser> baseResponse;
        String redisKey = CACHE_KEY_PREFIX_GETUSER + (userid == null ? "null" : userid);
        BoundValueOperations opts = this.redisTemplate.boundValueOps((Object)redisKey);
        WeworkUser weworkUser = (WeworkUser)opts.get();
        if (weworkUser == null || StringUtils.isEmpty((Object)weworkUser.getUserid())) {
            baseResponse = super.userGet(userid);
            if (baseResponse != null && baseResponse.getSuccess().booleanValue()) {
                weworkUser = baseResponse.getData();
                opts.set((Object)weworkUser, this.getWeworkProperties().getApi().getCacheExpires().longValue(), TimeUnit.SECONDS);
            }
        } else {
            baseResponse = new BaseResponse();
            baseResponse.setSuccess(true);
            baseResponse.setData(weworkUser);
        }
        return baseResponse;
    }

    @Override
    public BaseWeworkResponse userUpdate(WeworkUser user) {
        return null;
    }

    @Override
    public BaseWeworkResponse userDelete(String userid) {
        return null;
    }

    @Override
    public BaseWeworkResponse userBatchDelete(List<String> useridList) {
        return null;
    }

    @Override
    public BaseResponse<List<WeworkUserSimple>> userSimpleList(String departmentId, Boolean fetchChild) throws ApiInvokeException, IOException {
        BaseResponse<Object> baseResponse = null;
        String redisKey = CACHE_KEY_PREFIX_USERLIST + (departmentId == null ? "null" : departmentId) + (fetchChild == null ? "null" : fetchChild);
        BoundValueOperations opts = this.redisTemplate.boundValueOps((Object)redisKey);
        List users = (List)opts.get();
        if (users == null) {
            baseResponse = super.userSimpleList(departmentId, fetchChild);
            if (baseResponse != null && baseResponse.isSuccess().booleanValue() && (users = (List)baseResponse.getData()) != null && users.size() > 0) {
                opts.set((Object)users, this.getWeworkProperties().getApi().getCacheExpires().longValue(), TimeUnit.SECONDS);
            }
        } else {
            baseResponse = new BaseResponse();
            baseResponse.setSuccess(true);
            baseResponse.setData(users);
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<List<WeworkUser>> userList(String departmentId, Boolean fetchChild) throws ApiInvokeException, IOException {
        BaseResponse<Object> baseResponse = null;
        String redisKey = CACHE_KEY_PREFIX_USERLIST + (departmentId == null ? "null" : departmentId) + (fetchChild == null ? "null" : fetchChild);
        BoundValueOperations opts = this.redisTemplate.boundValueOps((Object)redisKey);
        List users = (List)opts.get();
        if (users == null) {
            baseResponse = super.userList(departmentId, fetchChild);
            if (baseResponse != null && baseResponse.isSuccess().booleanValue() && (users = (List)baseResponse.getData()) != null && users.size() > 0) {
                opts.set((Object)users, this.getWeworkProperties().getApi().getCacheExpires().longValue(), TimeUnit.SECONDS);
            }
        } else {
            baseResponse = new BaseResponse();
            baseResponse.setSuccess(true);
            baseResponse.setData(users);
        }
        return baseResponse;
    }

    @Override
    public OpenIdWeworkResponse userId2OpenId(String userid) {
        return null;
    }

    @Override
    public BaseResponse<String> openId2UserId(String openId) throws ApiInvokeException, IOException {
        BaseResponse<Object> baseResponse = new BaseResponse();
        String redisKey = CACHE_KEY_PREFIX_OPENID2USERID + (openId == null ? "null" : openId);
        BoundValueOperations opts = this.redisTemplate.boundValueOps((Object)redisKey);
        String userId = (String)opts.get();
        if (StringUtils.isEmpty((Object)userId)) {
            baseResponse = super.openId2UserId(openId);
            if (baseResponse != null && baseResponse.isSuccess().booleanValue() && !StringUtils.isEmpty((Object)(userId = (String)baseResponse.getData()))) {
                opts.set((Object)userId, this.getWeworkProperties().getApi().getCacheExpires().longValue(), TimeUnit.SECONDS);
            }
        } else {
            baseResponse.setSuccess(true);
            baseResponse.setData(userId);
        }
        return baseResponse;
    }

    @Override
    public BaseWeworkResponse userAuthSuccess(String userid) {
        return null;
    }

    @Override
    public BaseResponse<List<WeworkDepartment>> listDepartments(String id) throws ApiInvokeException, IOException {
        BaseResponse<Object> baseResponse = new BaseResponse();
        String redisKey = CACHE_KEY_PREFIX_DEPARTMENTLIST + (id == null ? "null" : id);
        BoundValueOperations opts = this.redisTemplate.boundValueOps((Object)redisKey);
        List departments = (List)opts.get();
        if (departments == null) {
            baseResponse = super.listDepartments(id);
            if (baseResponse != null && baseResponse.isSuccess().booleanValue() && (departments = (List)baseResponse.getData()) != null && departments.size() > 0) {
                opts.set((Object)departments, this.getWeworkProperties().getApi().getCacheExpires().longValue(), TimeUnit.SECONDS);
            }
        } else {
            baseResponse.setSuccess(true);
            baseResponse.setData(departments);
        }
        return baseResponse;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

