/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.picc.gz.platform.weworkapi.api.JsapiTicketApi;
import com.picc.gz.platform.weworkapi.api.impl.BaseJsapiTicketApi;
import com.picc.gz.platform.weworkapi.common.Constant;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.wework.JsapiTicket;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCachedJsapiTicketApi
extends BaseJsapiTicketApi
implements JsapiTicketApi {
    private static final String CACHE_KEY_TEMPLATE_JSAPITICKET = "wework:cache:jsapiticket:%s_TICKET";
    private static final String CACHE_KEY_TEMPLATE_JSAPITICKET_REFRESH_TIME = "wework:cache:jsapiticket:%s_LASTREFRESHED";
    private static final String CACHE_KEY_TEMPLATE_JSAPITICKET_EXPIRES = "wework:cache:jsapiticket:%s_EXPIRES";
    private RedisTemplate redisTemplate;

    public RedisCachedJsapiTicketApi(RedisTemplate redisTemplate, WeworkAppProperties weworkProperties, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        super(weworkProperties, httpHelper, uriTemplateHelper);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public BaseResponse<JsapiTicket> getCorp(String accessToken) throws ApiInvokeException {
        return this.getJsapiTicket(accessToken, "");
    }

    @Override
    public BaseResponse<JsapiTicket> getApp(String accessToken) throws ApiInvokeException {
        return this.getJsapiTicket(accessToken, "agent_config");
    }

    private BaseResponse<JsapiTicket> getJsapiTicket(String accessToken, String type) throws ApiInvokeException {
        String key = String.format("%s_%s", accessToken, type);
        BoundValueOperations tokenExpriesOpts = this.redisTemplate.boundValueOps((Object)String.format(CACHE_KEY_TEMPLATE_JSAPITICKET_EXPIRES, key));
        BoundValueOperations tokenLastRefreshOpts = this.redisTemplate.boundValueOps((Object)String.format(CACHE_KEY_TEMPLATE_JSAPITICKET_REFRESH_TIME, key));
        BoundValueOperations tokenOpts = this.redisTemplate.boundValueOps((Object)String.format(CACHE_KEY_TEMPLATE_JSAPITICKET, key));
        BaseResponse<JsapiTicket> baseResponse = null;
        Date lastRefreshTime = (Date)tokenLastRefreshOpts.get();
        if (lastRefreshTime != null) {
            Long expries = (Long)tokenExpriesOpts.get();
            expries = expries == null ? 7200L : expries;
            Calendar cLastRefreshed = Calendar.getInstance();
            cLastRefreshed.setTime(lastRefreshTime);
            cLastRefreshed.add(13, expries.intValue());
            if (cLastRefreshed.compareTo(Calendar.getInstance()) >= 0) {
                tokenExpriesOpts.expire(expries.longValue(), TimeUnit.SECONDS);
                tokenExpriesOpts.set((Object)expries);
                JsapiTicket ticket = new JsapiTicket();
                ticket.setTicket((String)tokenOpts.get());
                ticket.setExpiresIn(new Long(expries));
                baseResponse = new BaseResponse();
                baseResponse.setSuccess(true);
                baseResponse.setErrcode(Constant.WeworkApiErrors.SUCCESS.getValue());
                baseResponse.setData(ticket);
            }
        }
        if ((baseResponse == null || baseResponse.getData() == null || ((JsapiTicket)baseResponse.getData()).getTicket() == null) && (baseResponse = super.get(accessToken, type)).getSuccess().booleanValue()) {
            Date refreshTime = new Date();
            JsapiTicket ticket = baseResponse.getData();
            tokenOpts.set((Object)ticket.getTicket(), ticket.getExpiresIn().longValue(), TimeUnit.SECONDS);
            tokenExpriesOpts.set((Object)ticket.getExpiresIn(), ticket.getExpiresIn().longValue(), TimeUnit.SECONDS);
            tokenLastRefreshOpts.set((Object)refreshTime, ticket.getExpiresIn().longValue(), TimeUnit.SECONDS);
        }
        return baseResponse;
    }
}

