/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.api.impl;

import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.OauthApi;
import com.picc.gz.platform.weworkapi.api.impl.BasicOauthApi;
import com.picc.gz.platform.weworkapi.config.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.response.UserInfo;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCachedOauthApi
extends BasicOauthApi
implements OauthApi {
    public static final String CACHE_KEY_PREFIX_OAUTH = "wework:api:cache:data:oauth:";
    private RedisTemplate redisTemplate;

    public RedisCachedOauthApi(RedisTemplate redisTemplate, WeworkAppProperties weworkProperties, AccessTokenApi accessTokenApi, HttpHelper httpHelper, UriTemplateHelper uriTemplateHelper) {
        super(weworkProperties, accessTokenApi, httpHelper, uriTemplateHelper);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public BaseResponse<UserInfo> getuserinfo(String code) throws ApiInvokeException, IOException {
        BaseResponse<Object> baseResponse = new BaseResponse();
        String redisKey = CACHE_KEY_PREFIX_OAUTH + (code == null ? "null" : code);
        BoundValueOperations opts = this.redisTemplate.boundValueOps((Object)redisKey);
        UserInfo userInfo = (UserInfo)opts.get();
        if (userInfo == null) {
            baseResponse = super.getuserinfo(code);
            if (baseResponse.getSuccess().booleanValue()) {
                opts.set((Object)userInfo, this.getWeworkProperties().getApi().getCacheExpires().longValue(), TimeUnit.SECONDS);
            }
        } else {
            baseResponse.setSuccess(true);
            baseResponse.setData(userInfo);
        }
        return baseResponse;
    }

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

