/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.helper.http.impl;

import com.alibaba.fastjson.JSON;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OkHttpHelper
implements HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(OkHttpHelper.class);
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient okHttpClient;

    public OkHttpHelper() {
    }

    public OkHttpHelper(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public Optional<String> get(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.okHttpClient.newCall(request).execute();
        String responseBody = response.body().string();
        log.info("responseBody-->{}", (Object)responseBody);
        return responseBody == null ? Optional.empty() : Optional.of(responseBody);
    }

    @Override
    public Optional<String> post(String url, Map<String, String> postData) throws IOException {
        FormBody.Builder requestBodyBuilder = new FormBody.Builder();
        if (postData != null) {
            for (Map.Entry<String, String> e : postData.entrySet()) {
                requestBodyBuilder.add(e.getKey(), e.getValue());
            }
        }
        FormBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        Response response = this.okHttpClient.newCall(request).execute();
        String responseBody = response.body().string();
        log.info("responseBody-->{}", (Object)responseBody);
        if (StringUtils.isEmpty((Object)responseBody)) {
            log.warn("\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            return Optional.empty();
        }
        return Optional.of(responseBody);
    }

    @Override
    public <T> Optional<T> getJSON(String url, Object data, Class<T> respClass) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.okHttpClient.newCall(request).execute();
        String responseBody = response.body().string();
        log.info("responseBody-->{}", (Object)responseBody);
        if (StringUtils.isEmpty((Object)responseBody)) {
            log.warn("\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            return Optional.empty();
        }
        Object parsedObject = JSON.parseObject((String)responseBody, respClass);
        return parsedObject == null ? Optional.empty() : Optional.of(parsedObject);
    }

    @Override
    public <T> Optional<T> postJSON(String url, Object data, Class<T> respClass) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)JSON.toJSONString((Object)data));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.okHttpClient.newCall(request).execute();
        String responseBody = response.body().string();
        log.info("responseBody-->{}", (Object)responseBody);
        if (StringUtils.isEmpty((Object)responseBody)) {
            log.warn("\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            return Optional.empty();
        }
        Object parsedObject = JSON.parseObject((String)responseBody, respClass);
        return parsedObject == null ? Optional.empty() : Optional.of(parsedObject);
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }
}

