/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.vo;

import com.alibaba.fastjson.JSON;
import com.picc.gz.platform.weworkapi.api.CorpUserApi;
import com.picc.gz.platform.weworkapi.exceptions.ApiInvokeException;
import com.picc.gz.platform.weworkapi.vo.response.BaseResponse;
import com.picc.gz.platform.weworkapi.vo.wework.WeworkDepartment;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepartmentTree
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DepartmentTree.class);
    private WeworkDepartment current;
    private DepartmentTree next;

    public static DepartmentTree setNextDepartmentTree(WeworkDepartment current, DepartmentTree next) {
        if (null == next.getCurrent()) {
            next.setCurrent(current);
            next.setNext(null);
            return next;
        }
        next.setNext(DepartmentTree.setNextDepartmentTree(current, next.getNext() == null ? new DepartmentTree() : next.getNext()));
        return next;
    }

    public static List<WeworkDepartment> getDepartmentById(List<WeworkDepartment> departments, String startId) {
        ArrayList<WeworkDepartment> resultList = new ArrayList<WeworkDepartment>();
        if ("1".equals(startId)) {
            return null;
        }
        for (int i = 0; i < departments.size(); ++i) {
            if (!departments.get(i).getId().equals(startId)) continue;
            resultList.add(departments.get(i));
            List<WeworkDepartment> list = DepartmentTree.getDepartmentById(departments, departments.get(i).getParentid());
            if (null == list || list.size() <= 0) break;
            resultList.addAll(list);
            break;
        }
        return resultList;
    }

    public static DepartmentTree getDepartmentTree(List<WeworkDepartment> departments, String startId) {
        if ("1".equals(startId)) {
            return null;
        }
        for (int i = 0; i < departments.size(); ++i) {
            if (!departments.get(i).getId().equals(startId)) continue;
            DepartmentTree next = DepartmentTree.getDepartmentTree(departments, departments.get(i).getParentid());
            if (null == next) {
                DepartmentTree cu = new DepartmentTree();
                cu.setCurrent(departments.get(i));
                cu.setNext(next);
                return cu;
            }
            return DepartmentTree.setNextDepartmentTree(departments.get(i), next);
        }
        return null;
    }

    public static List<WeworkDepartment> getDepartmentTreeGetList(DepartmentTree departmentTree) {
        ArrayList<WeworkDepartment> departmentList = new ArrayList<WeworkDepartment>();
        while (null != departmentTree) {
            departmentList.add(departmentTree.getCurrent());
            departmentTree = departmentTree.getNext();
        }
        return departmentList;
    }

    public static DepartmentTree getTree(String pId, String startId, List<WeworkDepartment> departments, CorpUserApi corpUserApi) throws IOException, ApiInvokeException {
        BaseResponse<List<WeworkDepartment>> weworkRes = corpUserApi.listDepartments(pId);
        if (null == weworkRes || !weworkRes.getSuccess().booleanValue()) {
            log.info("\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\uff1a" + JSON.toJSONString(weworkRes));
            return null;
        }
        departments.addAll((Collection<WeworkDepartment>)weworkRes.getData());
        DepartmentTree resultTree = DepartmentTree.getDepartmentTree(departments, startId);
        if (null != resultTree && null != resultTree.getCurrent() && resultTree.getCurrent().getParentid().equals("1")) {
            return resultTree;
        }
        departments = DepartmentTree.getDepartmentTreeGetList(resultTree);
        return DepartmentTree.getTree(resultTree.getCurrent().getParentid(), startId, departments, corpUserApi);
    }

    public static DepartmentTree getSuperiorDepartmentTree(List<WeworkDepartment> departments, String superiorId) {
        for (WeworkDepartment weworkDepartment : departments) {
            if (!weworkDepartment.getId().equals(superiorId)) continue;
            DepartmentTree cu = new DepartmentTree();
            cu.setCurrent(weworkDepartment);
            return cu;
        }
        return null;
    }

    public static DepartmentTree getDepartmentTree(DepartmentTree departmentTree, String currentId, CorpUserApi corpUserApi) throws IOException, ApiInvokeException {
        BaseResponse<List<WeworkDepartment>> weworkRes = corpUserApi.listDepartments(currentId);
        if (null == weworkRes || !weworkRes.getSuccess().booleanValue()) {
            log.info("\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\uff1a" + JSON.toJSONString(weworkRes));
            return departmentTree;
        }
        if (null == weworkRes.getData() || weworkRes.getData().size() == 0) {
            log.info("\u83b7\u53d6\u90e8\u95e8\u6570\u636e\u4e3a\u7a7a\uff1a" + JSON.toJSONString(weworkRes));
            return departmentTree;
        }
        if (null == departmentTree) {
            departmentTree = DepartmentTree.getDepartmentTree(weworkRes.getData(), currentId);
            if (null == departmentTree) {
                log.info("\u627e\u4e0d\u5230\u8be5\u90e8\u95e8\u4fe1\u606f\uff1a" + currentId);
                return null;
            }
            return DepartmentTree.getDepartmentTree(departmentTree, departmentTree.getCurrent().getParentid(), corpUserApi);
        }
        DepartmentTree departmentTree1 = DepartmentTree.getDepartmentTree(weworkRes.getData(), currentId);
        if (null == departmentTree1) {
            log.info("\u627e\u4e0d\u5230\u8be5\u4e0a\u7ea7\u90e8\u95e8\u4fe1\u606f\uff1a" + currentId);
            return departmentTree;
        }
        departmentTree1.setNext(departmentTree);
        if (departmentTree1.getCurrent().getParentid().equals("1")) {
            return departmentTree1;
        }
        return DepartmentTree.getDepartmentTree(departmentTree1, departmentTree1.getCurrent().getParentid(), corpUserApi);
    }

    public WeworkDepartment getCurrent() {
        return this.current;
    }

    public DepartmentTree getNext() {
        return this.next;
    }

    public void setCurrent(WeworkDepartment current) {
        this.current = current;
    }

    public void setNext(DepartmentTree next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepartmentTree)) {
            return false;
        }
        DepartmentTree other = (DepartmentTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WeworkDepartment this$current = this.getCurrent();
        WeworkDepartment other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !this$current.equals(other$current)) {
            return false;
        }
        DepartmentTree this$next = this.getNext();
        DepartmentTree other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DepartmentTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WeworkDepartment $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : $current.hashCode());
        DepartmentTree $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public String toString() {
        return "DepartmentTree(current=" + this.getCurrent() + ", next=" + this.getNext() + ")";
    }

    public DepartmentTree() {
    }

    public DepartmentTree(WeworkDepartment current, DepartmentTree next) {
        this.current = current;
        this.next = next;
    }
}

