/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.autoconfig;

import com.picc.gz.platform.weworkapi.api.AccessTokenApi;
import com.picc.gz.platform.weworkapi.api.CorpUserApi;
import com.picc.gz.platform.weworkapi.api.MessageApi;
import com.picc.gz.platform.weworkapi.api.OauthApi;
import com.picc.gz.platform.weworkapi.api.impl.RedisCachedAccessTokenApi;
import com.picc.gz.platform.weworkapi.api.impl.RedisCachedCorpUserApi;
import com.picc.gz.platform.weworkapi.api.impl.RedisCachedMessageApi;
import com.picc.gz.platform.weworkapi.api.impl.RedisCachedOauthApi;
import com.picc.gz.platform.weworkapi.autoconfig.WeworkApiProperties;
import com.picc.gz.platform.weworkapi.autoconfig.WeworkAppProperties;
import com.picc.gz.platform.weworkapi.config.WeworkProperties;
import com.picc.gz.platform.weworkapi.helper.http.HttpHelper;
import com.picc.gz.platform.weworkapi.helper.http.UriTemplateHelper;
import com.picc.gz.platform.weworkapi.helper.http.impl.DefaultUriTemplateHelper;
import com.picc.gz.platform.weworkapi.helper.http.impl.OkHttpHelper;
import com.picc.gz.platform.weworkapi.interceptor.OkHttp3HttpLoggingInterceptor;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableConfigurationProperties(value={WeworkApiProperties.class, WeworkAppProperties.class})
public class WeworkConfigs {
    @Bean
    public OkHttpClient okHttpClient(@Autowired List<Interceptor> interceptors) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
        return builder.build();
    }

    @Bean
    public OkHttp3HttpLoggingInterceptor okHttp3HttpLoggingInterceptor() {
        return new OkHttp3HttpLoggingInterceptor();
    }

    @Bean
    public HttpHelper httpHelper(@Autowired OkHttpClient okHttpClient) {
        OkHttpHelper httpHelper = new OkHttpHelper(okHttpClient);
        return httpHelper;
    }

    @Bean
    public UriTemplateHelper uriTemplateHelper() {
        DefaultUriTemplateHelper uriTemplateHelper = new DefaultUriTemplateHelper();
        return uriTemplateHelper;
    }

    @Bean
    public WeworkProperties weworkProperties(@Autowired WeworkApiProperties weworkApiProperties, @Autowired WeworkAppProperties weworkAppProperties) {
        WeworkProperties weworkProperties = new WeworkProperties();
        com.picc.gz.platform.weworkapi.config.WeworkApiProperties api = new com.picc.gz.platform.weworkapi.config.WeworkApiProperties();
        BeanUtils.copyProperties((Object)weworkApiProperties, (Object)api);
        BeanUtils.copyProperties((Object)weworkAppProperties, (Object)weworkProperties, (String[])new String[]{"api"});
        weworkProperties.setApi(api);
        return weworkProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={AccessTokenApi.class})
    public AccessTokenApi accessTokenApi(@Autowired RedisTemplate redisTemplate, @Autowired WeworkProperties weworkProperties, @Autowired HttpHelper httpHelper, @Autowired UriTemplateHelper uriTemplateHelper) {
        RedisCachedAccessTokenApi accessTokenApi = new RedisCachedAccessTokenApi(redisTemplate, weworkProperties, httpHelper, uriTemplateHelper);
        return accessTokenApi;
    }

    @Bean
    @ConditionalOnMissingBean(value={CorpUserApi.class})
    public CorpUserApi corpUserApi(@Autowired RedisTemplate redisTemplate, @Autowired WeworkProperties weworkProperties, @Autowired AccessTokenApi accessTokenApi, @Autowired HttpHelper httpHelper, @Autowired UriTemplateHelper uriTemplateHelper) {
        RedisCachedCorpUserApi corpUserApi = new RedisCachedCorpUserApi(redisTemplate, weworkProperties, accessTokenApi, httpHelper, uriTemplateHelper);
        return corpUserApi;
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageApi.class})
    public MessageApi messageApi(@Autowired RedisTemplate redisTemplate, @Autowired WeworkProperties weworkProperties, @Autowired AccessTokenApi accessTokenApi, @Autowired HttpHelper httpHelper, @Autowired UriTemplateHelper uriTemplateHelper) {
        RedisCachedMessageApi messageApi = new RedisCachedMessageApi(redisTemplate, weworkProperties, accessTokenApi, httpHelper, uriTemplateHelper);
        return messageApi;
    }

    @Bean(value={"oauthApi"})
    @ConditionalOnMissingBean(value={OauthApi.class})
    public OauthApi oauthApi(@Autowired RedisTemplate redisTemplate, @Autowired WeworkProperties weworkProperties, @Autowired AccessTokenApi accessTokenApi, @Autowired HttpHelper httpHelper, @Autowired UriTemplateHelper uriTemplateHelper) {
        RedisCachedOauthApi oauthApi = new RedisCachedOauthApi(redisTemplate, weworkProperties, accessTokenApi, httpHelper, uriTemplateHelper);
        return oauthApi;
    }
}

