/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.platform.weworkapi.interceptor;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttp3HttpLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OkHttp3HttpLoggingInterceptor.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:S");
        Request request = chain.request();
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        StringBuilder message = new StringBuilder();
        String startTime = sdf.format(new Date());
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        String endTime = sdf.format(new Date());
        ResponseBody responseBody = response.body();
        message.append("Http Request [").append(request.method()).append(" ").append(request.url()).append(" ").append(OkHttp3HttpLoggingInterceptor.protocol(protocol)).append("] Finished in ").append(tookMs).append("ms");
        message.append("\r\n");
        message.append(startTime).append(" --> ").append(hasRequestBody ? requestBody.contentLength() : 0L).append("-byte body").append(" ");
        if (requestBody != null) {
            message.append(" [").append(requestBody.contentType().toString()).append("] ");
        }
        if (hasRequestBody) {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                contentType.charset(UTF8);
            }
            message.append("\r\nRequestBody: ").append(buffer.readString(charset));
        }
        message.append("\r\n").append(endTime).append(" <-- ");
        if (response != null) {
            message.append(OkHttp3HttpLoggingInterceptor.protocol(response.protocol())).append(" ").append(response.code()).append(" ").append(response.message()).append(", ").append(responseBody == null ? 0L : responseBody.contentLength()).append("-byte body").append(" ");
        }
        if (responseBody != null) {
            message.append(" [").append(responseBody.contentType()).append("] ");
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Charset charset = UTF8;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (responseBody.contentLength() != 0L) {
                message.append("\r\nResponseBody: ").append(buffer.clone().readString(charset));
            }
        }
        log.info(message.toString());
        return response;
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }

    private static String protocol(Protocol protocol) {
        return protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1";
    }
}

