/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa;

import com.sinosoftgz.starter.generator.jpa.BaseGenerator;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.GenType;
import com.sinosoftgz.starter.generator.jpa.executer.ControllerExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.DtoExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.JpaExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.MyBatisBaseCommonXmlExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.MyBatisCustomCommonXmlExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.PoExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.ServiceExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.ServiceImplExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.SpecificationExecuter;
import com.sinosoftgz.starter.generator.jpa.executer.VoExecuter;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator
extends BaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    private GenFileInfo poInfo;
    private GenFileInfo jpaInfo;
    private GenFileInfo voInfo;
    private GenFileInfo dtoInfo;
    private GenFileInfo specificationInfo;
    private GenFileInfo serviceInfo;
    private GenFileInfo serviceImplInfo;
    private GenFileInfo controllerInfo;

    private String assemblePackage(String module, String catalog) {
        String result = this.genConfig.getBasePackage() + "." + module;
        if (catalog != null && catalog.trim().length() > 0) {
            result = result + "." + catalog;
        }
        return result;
    }

    private static String assembleXmlPackage(String module) {
        String result = "";
        result = module != null && module.trim().length() > 0 ? module : "misc";
        return result;
    }

    private void resetFileInfo(String keyNameIn, String module) {
        String saveDir = this.genConfig.getSaveDir();
        String keyName = keyNameIn;
        if (this.genConfig.getIgnoreTablePrefixs() != null) {
            for (String ignoreTablePrefix : this.genConfig.getIgnoreTablePrefixs()) {
                ignoreTablePrefix = ignoreTablePrefix.replace("_", "");
                if (!keyName.toLowerCase(Locale.getDefault()).startsWith(ignoreTablePrefix.toLowerCase(Locale.getDefault()))) continue;
                keyName = keyName.substring(ignoreTablePrefix.length());
                break;
            }
        }
        String name = keyName + "VO";
        String packageName = this.assemblePackage(module, "vo");
        String path = Generator.getFilePath(this.genConfig.getSaveDirForVo(), Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.VO));
        this.voInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "DTO";
        packageName = this.assemblePackage(module, "dto");
        path = Generator.getFilePath(this.genConfig.getSaveDirForDto(), Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.DTO));
        this.dtoInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName;
        if (this.genConfig.keepPrefixForPO) {
            name = keyNameIn;
        }
        packageName = this.assemblePackage(module, "po");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.PO));
        this.poInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "Specification";
        packageName = this.assemblePackage(module, "specification");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.SPECIFICATION));
        this.specificationInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "Repos";
        packageName = this.assemblePackage(module, "repository");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.JPA));
        this.jpaInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "Service";
        packageName = this.assemblePackage(module, "service");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.SERVICE));
        this.serviceInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "ServiceImpl";
        packageName = this.assemblePackage(module, "service.impl");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.SERVICEIMPL));
        this.serviceImplInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "Controller";
        packageName = this.assemblePackage(module, "controller");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName), this.containsGenType(GenType.CONTROLLER));
        this.controllerInfo = new GenFileInfo(name, packageName, path, keyName);
    }

    @Override
    protected void run(Table table, String module) throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Generator.class, "/templates"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        log.info("============\u5904\u7406\u8868" + table.getName() + "==================");
        if (table.getPrimaryKeys().isEmpty()) {
            log.info("\u8868" + table.getName() + "\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5\uff0c\u5ffd\u7565\u751f\u6210\uff0c\u8bf7\u624b\u5de5\u7f16\u5199.");
            return;
        }
        String beanName = GeneratorUtils.getObjectName(table.getName());
        this.resetFileInfo(beanName, module);
        this.fileOvervide = false;
        if (this.containsGenType(GenType.VO) && this.validFile(this.voInfo.getPath(), this.voInfo.getName(), ".java")) {
            new VoExecuter(cfg, this.genConfig, this.voInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.DTO) && this.validFile(this.dtoInfo.getPath(), this.dtoInfo.getName(), ".java")) {
            new DtoExecuter(cfg, this.genConfig, this.dtoInfo).build(table);
        }
        this.fileOvervide = true;
        if (this.containsGenType(GenType.PO) && this.validFile(this.poInfo.getPath(), this.poInfo.getName(), ".java")) {
            new PoExecuter(cfg, this.genConfig, this.poInfo).build(table);
        }
        if (table.getPrimaryKeys().size() > 1) {
            log.info("\u8868" + table.getName() + "\u4e3a\u8054\u5408\u4e3b\u952e\uff0c\u5ffd\u7565dao\u548cmapper\u751f\u6210,\u8bf7\u624b\u5de5\u7f16\u5199.");
            return;
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.JPA) && this.validFile(this.jpaInfo.getPath(), this.jpaInfo.getName(), ".java")) {
            new JpaExecuter(cfg, this.genConfig, this.jpaInfo, this.poInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.SPECIFICATION) && this.validFile(this.specificationInfo.getPath(), this.specificationInfo.getName(), ".java")) {
            new SpecificationExecuter(this.genConfig, this.specificationInfo, this.poInfo, cfg).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.SERVICE) && this.validFile(this.serviceInfo.getPath(), this.serviceInfo.getName(), ".java")) {
            new ServiceExecuter(cfg, this.genConfig, this.serviceInfo, this.poInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.SERVICEIMPL) && this.validFile(this.serviceImplInfo.getPath(), this.serviceImplInfo.getName(), ".java")) {
            new ServiceImplExecuter(cfg, this.genConfig, this.serviceInfo, this.serviceImplInfo, this.poInfo, this.jpaInfo, this.specificationInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.CONTROLLER) && this.validFile(this.controllerInfo.getPath(), this.controllerInfo.getName(), ".java")) {
            new ControllerExecuter(cfg, this.genConfig, this.controllerInfo).build(table);
        }
    }

    @Override
    protected void runCommon() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Generator.class, "/templates"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        this.fileOvervide = true;
        if (this.containsGenType(GenType.BASE_MAPPER_XML) && this.validFile(this.genConfig.getSaveDirForXml(), "base/common", ".xml")) {
            new MyBatisBaseCommonXmlExecuter(cfg, this.genConfig).build();
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.MAPPER_XML) && this.validFile(this.genConfig.getSaveDirForXml(), "common/common", ".xml")) {
            new MyBatisCustomCommonXmlExecuter(cfg, this.genConfig).build();
        }
    }
}

