/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.freemarker.FreeMarkerUtils;
import com.sinosoftgz.starter.generator.jpa.schema.Column;
import com.sinosoftgz.starter.generator.jpa.schema.PrimaryKey;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(DaoExecuter.class);
    private GenFileInfo daoInfo;
    private GenFileInfo poInfo;
    private Configuration cfg;

    public DaoExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo daoInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.daoInfo = daoInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        if (primaryKeys.size() != 1) {
            throw new IllegalArgumentException("\u76ee\u524d\u53ea\u652f\u6301\u5355\u4e00\u4e3b\u952e\u7684\u8868");
        }
        PrimaryKey primaryKey = primaryKeys.get(0);
        Column idColumn = null;
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!column.getName().equalsIgnoreCase(primaryKey.getColumnName())) continue;
            idColumn = column;
            break;
        }
        if (idColumn == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u4e3b\u952e\u540d\u5bf9\u5e94\u7684\u5b57\u6bb5");
        }
        File targetFile = new File(this.daoInfo.getPath(), this.daoInfo.getName() + ".java");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("daoInfo", this.daoInfo);
        root.put("table", table);
        root.put("poInfo", this.poInfo);
        root.put("idColumn", idColumn);
        root.put("username", System.getProperty("user.name"));
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        root.put("createTime", myFmt.format(new Date()));
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("dao.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate Dao file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

