/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(DtoExecuter.class);
    private GenFileInfo dtoInfo;
    private Configuration cfg;

    public DtoExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo dtoInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.dtoInfo = dtoInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("dtoInfo", this.dtoInfo);
        root.put("table", table);
        root.put("containsDate", GeneratorUtils.containsDate(types));
        root.put("containsBigDecimal", GeneratorUtils.containsBigDecimal(types));
        File targetFile = new File(this.dtoInfo.getPath(), this.dtoInfo.getName() + ".java");
        GeneratorUtils.generatorCommonInfo(this.cfg, targetFile, root, "dto.ftlh", "DTO");
    }
}

