/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.schema.Column;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(JpaExecuter.class);
    private GenFileInfo jpaInfo;
    private GenFileInfo poInfo;
    private Configuration cfg;

    public JpaExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo jpaInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.jpaInfo = jpaInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        Column idColumn = GeneratorUtils.generatorColumn(table);
        File targetFile = new File(this.jpaInfo.getPath(), this.jpaInfo.getName() + ".java");
        ConcurrentHashMap<Object, Object> root = new ConcurrentHashMap<Object, Object>();
        root.put("jpaInfo", this.jpaInfo);
        root.put("table", table);
        root.put("poInfo", this.poInfo);
        root.put("idColumn", idColumn);
        GeneratorUtils.generatorCommonInfo(this.cfg, targetFile, root, "jpa.ftlh", "JPA");
    }
}

