/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.freemarker.FreeMarkerUtils;
import com.sinosoftgz.starter.generator.jpa.schema.PrimaryKey;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisBaseXmlExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisBaseXmlExecuter.class);
    private GenFileInfo baseMapperXmlInfo;
    private GenFileInfo daoInfo;
    private GenFileInfo poInfo;
    private Configuration cfg;

    public MyBatisBaseXmlExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo baseMapperXmlInfo, GenFileInfo daoInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.baseMapperXmlInfo = baseMapperXmlInfo;
        this.daoInfo = daoInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        File targetFile = new File(this.baseMapperXmlInfo.getPath(), this.baseMapperXmlInfo.getName() + ".xml");
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        PrimaryKey primaryKey = primaryKeys.get(0);
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("genConfig", this.genConfig);
        root.put("daoInfo", this.daoInfo);
        root.put("poInfo", this.poInfo);
        root.put("table", table);
        root.put("primaryKey", primaryKey);
        root.put("isAutoIncrementPK", GeneratorUtils.isAutoIncrementPK(table));
        root.put("hasOperateTimeForHis", GeneratorUtils.hasColumn(table, this.genConfig.getOperateTimeForHisName()));
        root.put("username", System.getProperty("user.name"));
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        root.put("createTime", myFmt.format(new Date()));
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("mybatis-base-mapper.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate mybatis base mapper file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

