/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.executer.CommonBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.freemarker.FreeMarkerUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisCustomCommonXmlExecuter
extends CommonBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisCustomCommonXmlExecuter.class);
    private Configuration cfg;

    public MyBatisCustomCommonXmlExecuter(Configuration cfg, GenConfig genConfig) {
        super(genConfig);
        this.cfg = cfg;
    }

    @Override
    public void build() throws IOException {
        File targetFile = new File(this.genConfig.getSaveDirForXml(), "custom/CommonDao.xml");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("genConfig", this.genConfig);
        root.put("username", System.getProperty("user.name"));
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        root.put("createTime", myFmt.format(new Date()));
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("mybatis-custom-common-mapper.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate mybatis custom common mapper file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

