/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.freemarker.FreeMarkerUtils;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisCustomXmlExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisCustomXmlExecuter.class);
    private GenFileInfo mapperXmlInfo;
    private GenFileInfo daoInfo;
    private Configuration cfg;

    public MyBatisCustomXmlExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo mapperXmlInfo, GenFileInfo daoInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.mapperXmlInfo = mapperXmlInfo;
        this.daoInfo = daoInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        File targetFile = new File(this.mapperXmlInfo.getPath(), this.mapperXmlInfo.getName() + ".xml");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("genConfig", this.genConfig);
        root.put("daoInfo", this.daoInfo);
        root.put("table", table);
        root.put("username", System.getProperty("user.name"));
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        root.put("createTime", myFmt.format(new Date()));
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("mybatis-custom-mapper.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate mybatis custom mapper file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

