/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.schema.Column;
import com.sinosoftgz.starter.generator.jpa.schema.PrimaryKey;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(ServiceExecuter.class);
    private GenFileInfo serviceInfo;
    private GenFileInfo poInfo;
    private Configuration cfg;

    public ServiceExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo serviceInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.serviceInfo = serviceInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        if (primaryKeys.size() != 1) {
            throw new IllegalArgumentException("\u76ee\u524d\u53ea\u652f\u6301\u5355\u4e00\u4e3b\u952e\u7684\u8868");
        }
        PrimaryKey primaryKey = primaryKeys.get(0);
        Column idColumn = null;
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!column.getName().equalsIgnoreCase(primaryKey.getColumnName())) continue;
            idColumn = column;
            break;
        }
        if (idColumn == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u4e3b\u952e\u540d\u5bf9\u5e94\u7684\u5b57\u6bb5");
        }
        File targetFile = new File(this.serviceInfo.getPath(), this.serviceInfo.getName() + ".java");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("serviceInfo", this.serviceInfo);
        root.put("table", table);
        root.put("poInfo", this.poInfo);
        root.put("idColumn", idColumn);
        GeneratorUtils.generatorCommonInfo(this.cfg, targetFile, root, "service.ftlh", "service");
    }
}

