/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.schema.Column;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImplExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(ServiceImplExecuter.class);
    private GenFileInfo serviceInfo;
    private GenFileInfo serviceImplInfo;
    private GenFileInfo poInfo;
    private GenFileInfo jpaInfo;
    private GenFileInfo specificationInfo;
    private Configuration cfg;

    public ServiceImplExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo serviceInfo, GenFileInfo serviceImplInfo, GenFileInfo poInfo, GenFileInfo jpaInfo, GenFileInfo specificationInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.serviceInfo = serviceInfo;
        this.serviceImplInfo = serviceImplInfo;
        this.poInfo = poInfo;
        this.jpaInfo = jpaInfo;
        this.specificationInfo = specificationInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        Column idColumn = GeneratorUtils.generatorColumn(table);
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        File targetFile = new File(this.serviceImplInfo.getPath(), this.serviceImplInfo.getName() + ".java");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("serviceInfo", this.serviceInfo);
        root.put("serviceImplInfo", this.serviceImplInfo);
        root.put("jpaInfo", this.jpaInfo);
        root.put("specificationInfo", this.specificationInfo);
        root.put("table", table);
        root.put("poInfo", this.poInfo);
        root.put("idColumn", idColumn);
        root.put("containsDate", GeneratorUtils.containsDate(types));
        root.put("containsBigDecimal", GeneratorUtils.containsBigDecimal(types));
        GeneratorUtils.generatorCommonInfo(this.cfg, targetFile, root, "serviceImpl.ftlh", "serviceImpl");
    }
}

