/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.executer;

import com.sinosoftgz.starter.generator.jpa.GenConfig;
import com.sinosoftgz.starter.generator.jpa.GenFileInfo;
import com.sinosoftgz.starter.generator.jpa.executer.TableBaseExecuter;
import com.sinosoftgz.starter.generator.jpa.schema.Column;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.GeneratorUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(SpecificationExecuter.class);
    private GenFileInfo specificationInfo;
    private GenFileInfo poInfo;
    private Configuration cfg;

    public SpecificationExecuter(GenConfig genConfig, GenFileInfo specificationInfo, GenFileInfo poInfo, Configuration cfg) {
        super(genConfig);
        this.specificationInfo = specificationInfo;
        this.poInfo = poInfo;
        this.cfg = cfg;
    }

    @Override
    public void build(Table table) throws IOException {
        Column idColumn = GeneratorUtils.generatorColumn(table);
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        File targetFile = new File(this.specificationInfo.getPath(), this.specificationInfo.getName() + ".java");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("specificationInfo", this.specificationInfo);
        root.put("table", table);
        root.put("poInfo", this.poInfo);
        root.put("idColumn", idColumn);
        root.put("containsDate", GeneratorUtils.containsDate(types));
        root.put("containsBigDecimal", GeneratorUtils.containsBigDecimal(types));
        GeneratorUtils.generatorCommonInfo(this.cfg, targetFile, root, "specification.ftlh", "specification");
    }
}

