/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.util;

import com.sinosoftgz.starter.generator.jpa.freemarker.FreeMarkerUtils;
import com.sinosoftgz.starter.generator.jpa.schema.Column;
import com.sinosoftgz.starter.generator.jpa.schema.PrimaryKey;
import com.sinosoftgz.starter.generator.jpa.schema.Table;
import com.sinosoftgz.starter.generator.jpa.util.WordFileUtils;
import com.sinosoftgz.starter.utils.date.DateUtils;
import com.sinosoftgz.starter.utils.lang.Lang;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorUtils {
    private static final Logger log = LoggerFactory.getLogger(GeneratorUtils.class);

    private GeneratorUtils() {
    }

    public static List<String> getTableColumnTypes(Table table) {
        ArrayList<String> types = new ArrayList<String>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            types.add(column.getType());
        }
        return types;
    }

    public static boolean hasColumn(Table table, String columnName) {
        boolean result = false;
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!GeneratorUtils.getObjectName(column.getName()).equalsIgnoreCase(columnName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static List<Column> getTablePrimaryKeysColumns(Table table) {
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnMap.put(column.getName().toLowerCase(Locale.getDefault()), column);
        }
        ArrayList<Column> result = new ArrayList<Column>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            result.add((Column)columnMap.get(primaryKey.getColumnName().toLowerCase(Locale.getDefault())));
        }
        return result;
    }

    public static String getKeyProperty(Table table) {
        Column column;
        List<Column> primaryKeysColumns = GeneratorUtils.getTablePrimaryKeysColumns(table);
        String result = "";
        if (primaryKeysColumns.size() == 1 && (column = primaryKeysColumns.get(0)).isAutoIncrement()) {
            result = column.getName();
        }
        return result;
    }

    public static boolean isAutoIncrementPK(Table table) {
        Column column;
        List<Column> primaryKeysColumns = GeneratorUtils.getTablePrimaryKeysColumns(table);
        return primaryKeysColumns.size() == 1 && (column = primaryKeysColumns.get(0)).isAutoIncrement();
    }

    public static List<String> getTablePrimaryKeysCloumnNames(Table table) {
        ArrayList<String> result = new ArrayList<String>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        int size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            result.add(primaryKey.getColumnName().toLowerCase(Locale.getDefault()));
        }
        return result;
    }

    public static List<String> getTablePrimaryKeysTypes(Table table) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnMap.put(column.getName().toLowerCase(Locale.getDefault()), column.getType());
        }
        ArrayList<String> types = new ArrayList<String>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            types.add((String)columnMap.get(primaryKey.getColumnName().toLowerCase(Locale.getDefault())));
        }
        return types;
    }

    public static boolean containsDate(List<String> types) {
        for (String type : types) {
            String t = type.toLowerCase(Locale.getDefault());
            if (!t.contains("date") && !t.contains("time")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsBigDecimal(List<String> types) {
        for (String type : types) {
            if (!type.toLowerCase(Locale.getDefault()).contains("number") && !type.toLowerCase(Locale.getDefault()).contains("numeric") && !type.toLowerCase(Locale.getDefault()).contains("decimal")) continue;
            return true;
        }
        return false;
    }

    public static String getInstanceName(String field) {
        return WordFileUtils.getBeautyInstanceName(field);
    }

    public static String getObjectName(String field) {
        return WordFileUtils.getBeautyObjectName(field);
    }

    public static void generatorCommonInfo(Configuration cfg, File targetFile, Map<Object, Object> root, String templateName, String desc) throws IOException {
        if (Lang.isEmpty((Object)templateName)) {
            throw new IllegalArgumentException("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        root.put("username", System.getProperty("user.name"));
        root.put("createTime", DateUtils.now((String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"));
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = cfg.getTemplate(templateName);
            template.process(root, (Writer)bw);
            log.info("Generate {} file {}", (Object)desc, (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static Column generatorColumn(Table table) {
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        if (primaryKeys.size() != 1) {
            throw new IllegalArgumentException("\u76ee\u524d\u53ea\u652f\u6301\u5355\u4e00\u4e3b\u952e\u7684\u8868");
        }
        PrimaryKey primaryKey = primaryKeys.get(0);
        Column idColumn = null;
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!column.getName().equalsIgnoreCase(primaryKey.getColumnName())) continue;
            idColumn = column;
            break;
        }
        if (idColumn == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u4e3b\u952e\u540d\u5bf9\u5e94\u7684\u5b57\u6bb5");
        }
        return idColumn;
    }
}

