/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.generator.jpa.util;

import com.sinosoftgz.starter.generator.jpa.util.Word;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WordFileUtils {
    private static final Logger log = LoggerFactory.getLogger(WordFileUtils.class);
    public static final String WORD_FILE_HOME = "wordfile.home";
    public static final String WORD_ROOT_FILE = "wordroot.properties";
    public static final String WORD_ROOT_TABLE_FILE = "wordroot-table.properties";
    private static Map<String, Word> wordMap = new HashMap<String, Word>();
    private static boolean hasShowHelp;
    private static final int MAX_WORDROOT_FILES = 9;
    private static final String UTF8 = "UTF-8";

    private WordFileUtils() {
    }

    public static synchronized void initWordMap() {
        String wordfileHome = System.getProperty(WORD_FILE_HOME, "");
        if (!hasShowHelp) {
            log.info("**************************************************************");
            log.info("**\u5f00\u59cb\u52a0\u8f7d\u8bcd\u6839\u8868\uff0c\u8bcd\u6839\u4f18\u5148\u7ea7\u5982\u4e0b\uff1a ");
            log.info("**1\uff1a\u4ee5\u4e0b\u5212\u7ebf\u5206\u9694\u7684\u547d\u540d");
            log.info("**2\uff1a\u81ea\u5e26\u6807\u51c6\u8bcd\u6839\u8868(wordroot.properties)");
            log.info("**3\uff1a\u81ea\u5e26\u6807\u51c6\u8bcd\u6839\u8868\u4e1a\u52a1\u8868(wordroot-table.properties)");
            log.info("**4\uff1a\u73af\u5883\u53d8\u91cfwordfile.home(\"" + wordfileHome + "\")\u4e0b\u81ea\u5b9a\u4e49\u8bcd\u6839\u8868\u6587\u4ef6(wordfile9.properties->wordfile9.properties)");
            log.info("**5\uff1aCLASSPATH\u4e0b\u81ea\u5b9a\u4e49\u8bcd\u6839\u8868\u6587\u4ef6(wordfile9.properties->wordfile9.properties)");
            log.info("**6\uff1a\u6570\u636e\u5e93\u4e2d\u7684\u5927\u5c0f\u5199");
            log.info("**7\uff1a\u5168\u90e8\u6539\u6210\u5c0f\u5199");
            log.info("**************************************************************");
            hasShowHelp = true;
        }
        try {
            int i;
            if (StringUtils.isNotBlank((CharSequence)wordfileHome)) {
                for (i = 9; i >= 1; --i) {
                    WordFileUtils.init(wordfileHome, "wordfile" + i + ".properties");
                }
            }
            for (i = 9; i >= 1; --i) {
                WordFileUtils.init("wordfile" + i + ".properties");
            }
            WordFileUtils.init(WORD_ROOT_TABLE_FILE);
            WordFileUtils.init(WORD_ROOT_FILE);
        }
        catch (IOException e) {
            log.warn("{}", (Throwable)e);
        }
    }

    private static String getClassNameWithoutPackage(Class<?> cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        return className.substring(pos);
    }

    public static String getRealPathName(Class<?> cl) {
        URL url = cl.getResource(WordFileUtils.getClassNameWithoutPackage(cl) + ".class");
        if (url != null) {
            return url.getPath();
        }
        return null;
    }

    private static void init(String path, String fileName) throws IOException {
        File file = new File(path, fileName);
        if (file.exists() && file.canRead()) {
            try (FileInputStream is = new FileInputStream(file);){
                log.info("Load wordfile " + fileName);
                PropertyResourceBundle bundle = new PropertyResourceBundle(is);
                Enumeration<String> ration = bundle.getKeys();
                while (ration.hasMoreElements()) {
                    String objKey = ration.nextElement();
                    if (objKey == null) continue;
                    String name = objKey;
                    String key = name.toLowerCase(Locale.getDefault());
                    String value = bundle.getString(name);
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    value = new String(value.getBytes(UTF8), Charset.defaultCharset());
                    Word word = new Word(name, value);
                    wordMap.put(key, word);
                }
            }
        } else {
            log.info("Skip wordfile " + file.getAbsolutePath());
        }
    }

    private static void init(String fileName) throws IOException {
        try (InputStream is = WordFileUtils.class.getClassLoader().getResourceAsStream(fileName);){
            if (is == null) {
                log.info("Skip wordfile " + fileName);
                return;
            }
            log.info("Load wordfile " + fileName);
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            Enumeration<String> ration = bundle.getKeys();
            while (ration.hasMoreElements()) {
                String objKey = ration.nextElement();
                if (objKey == null) continue;
                String name = objKey;
                String key = name.toLowerCase(Locale.getDefault());
                String value = bundle.getString(name);
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                value = new String(value.getBytes(UTF8), Charset.defaultCharset());
                Word word = new Word(name, value);
                wordMap.put(key, word);
            }
        }
    }

    public static String getBeautyObjectName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must have value.");
        }
        String key = name.toLowerCase(Locale.getDefault());
        key = key.replace("_", "");
        String beautyName = null;
        if (name.contains("_")) {
            StringBuilder sb = new StringBuilder();
            String[] fields = name.split("_");
            sb.append(fields[0].toLowerCase(Locale.getDefault()));
            for (int i = 1; i < fields.length; ++i) {
                String temp = fields[i];
                sb.append(temp.substring(0, 1).toUpperCase(Locale.getDefault()));
                sb.append(temp.substring(1).toLowerCase(Locale.getDefault()));
            }
            beautyName = sb.toString();
        } else if (wordMap.containsKey(key)) {
            beautyName = wordMap.get(key).getName();
            beautyName = WordFileUtils.upperCaseFirstChar(beautyName);
        } else {
            beautyName = !name.toUpperCase(Locale.US).equals(name) && !name.toLowerCase(Locale.US).equals(name) ? name : name.toLowerCase(Locale.getDefault());
        }
        beautyName = WordFileUtils.upperCaseFirstChar(beautyName);
        return beautyName;
    }

    public static String getBeautyInstanceName(String name) {
        String beautyName = WordFileUtils.getBeautyObjectName(name);
        if (beautyName.length() <= 1 || !Character.isUpperCase(beautyName.charAt(1))) {
            beautyName = WordFileUtils.lowerCaseFirstChar(beautyName);
        }
        return beautyName;
    }

    public static String getBeautyDesc(String name) {
        String beautyDesc = "";
        String key = name.toLowerCase(Locale.getDefault());
        beautyDesc = wordMap.containsKey(key = key.replace("_", "")) ? wordMap.get(key).getDesc() : name;
        return beautyDesc;
    }

    public static String lowerCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toLowerCase(Locale.getDefault()) + iString.substring(1);
        return newString;
    }

    public static String upperCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toUpperCase(Locale.getDefault()) + iString.substring(1);
        return newString;
    }

    public static String getGetMethod(String name) {
        return "get" + WordFileUtils.upperCaseFirstChar(WordFileUtils.getBeautyInstanceName(name)) + "()";
    }

    public static void printString(String value) {
        try {
            int i;
            String[] codes = new String[]{"GBK", "ISO8859-1", UTF8};
            for (i = 0; i < codes.length; ++i) {
                for (int j = 0; j < codes.length; ++j) {
                    if (i == j) continue;
                    log.info(codes[i] + "--" + codes[j] + "====" + new String(value.getBytes(codes[i]), codes[j]));
                }
            }
            for (i = 0; i < codes.length; ++i) {
                log.info(codes[i] + "====" + new String(value.getBytes(codes[i]), Charset.defaultCharset()));
            }
            for (i = 0; i < codes.length; ++i) {
                log.info(codes[i] + "==----==" + new String(value.getBytes(Charset.defaultCharset()), codes[i]));
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
    }
}

