/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.config.refresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.sinosoftgz.global.common.utils.LangUtils;
import com.sinosoftgz.starter.config.annotation.RefreshBean;
import com.sinosoftgz.starter.config.cache.BeanCache;
import com.sinosoftgz.starter.config.properties.InsConfigProperties;
import com.sinosoftgz.starter.config.utils.ArraysUtils;
import com.sinosoftgz.starter.config.utils.LogChangeKeyUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ConditionalOnPropertyRefreshConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ConditionalOnPropertyRefreshConfig.class);
    private static final String LOG_TITLE = "\u5237\u65b0\u5e26\u6709@ConditionalOnProperty\u6ce8\u89e3\u7684bean";
    private ApplicationContext applicationContext;
    @ApolloConfig
    private Config config;
    @Resource
    private BeanCache beanCache;
    private final InsConfigProperties insConfigProperties;

    public ConditionalOnPropertyRefreshConfig(InsConfigProperties insConfigProperties, ApplicationContext applicationContext) {
        this.insConfigProperties = insConfigProperties;
        this.applicationContext = applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ApolloConfigChangeListener
    private void refresh(ConfigChangeEvent changeEvent) {
        log.info("\u5237\u65b0\u5e26\u6709@ConditionalOnProperty\u6ce8\u89e3\u7684bean The to refresh bean name is {}. ", (Object)this.insConfigProperties.getToRefreshBeanNames());
        Optional<String[]> beanArrayOptional = this.insConfigProperties.toRefreshBeanNameArray();
        if (beanArrayOptional.isPresent()) {
            Collection<Class> conditionalClasses = this.beanCache.getConditionalClassesMap().values();
            if (!CollectionUtils.isEmpty(conditionalClasses)) {
                for (Class conditionalClass : conditionalClasses) {
                    String conditionalOnPropertyValue;
                    String[] conditionalOnPropertyKeys;
                    String beanChangeCondition;
                    boolean isChangeBean;
                    ConditionalOnProperty conditionalOnProperty = conditionalClass.getAnnotation(ConditionalOnProperty.class);
                    if (conditionalOnProperty == null || (isChangeBean = this.changeBean(conditionalClass, beanChangeCondition = this.getChangeKey(changeEvent, conditionalOnPropertyKeys = conditionalOnProperty.name()), conditionalOnPropertyValue = conditionalOnProperty.havingValue()))) continue;
                    this.applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changeEvent.changedKeys()));
                }
            }
            LogChangeKeyUtils.printChange(LOG_TITLE, this.insConfigProperties.isEnabledLog(), changeEvent);
        }
    }

    private boolean isChangeKey(ConfigChangeEvent changeEvent, String conditionalOnPropertyKey) {
        Set changeKeys = changeEvent.changedKeys();
        return !CollectionUtils.isEmpty((Collection)changeKeys) && changeKeys.contains(conditionalOnPropertyKey);
    }

    private String getChangeKey(ConfigChangeEvent changeEvent, String[] conditionalOnPropertyKeys) {
        if (ArraysUtils.isEmpty(conditionalOnPropertyKeys)) {
            return null;
        }
        String changeKey = null;
        for (String conditionalOnPropertyKey : conditionalOnPropertyKeys) {
            if (!this.isChangeKey(changeEvent, conditionalOnPropertyKey)) continue;
            changeKey = conditionalOnPropertyKey;
            break;
        }
        return changeKey;
    }

    private boolean changeBean(Class conditionalClass, String beanChangeCondition, String conditionalOnPropertyValue) {
        boolean isNeedRegisterBeanIfKeyChange = this.isNeedRegisterBeanIfKeyChange(beanChangeCondition, conditionalOnPropertyValue);
        boolean isNeedRemoveBeanIfKeyChange = this.isNeedRemoveBeanIfKeyChange(beanChangeCondition, conditionalOnPropertyValue);
        String beanName = StringUtils.uncapitalize((String)conditionalClass.getSimpleName());
        if (isNeedRegisterBeanIfKeyChange) {
            boolean isAlreadyRegisterBean = this.isExistBean(beanName);
            if (!isAlreadyRegisterBean) {
                this.registerBean(beanName, conditionalClass);
                return true;
            }
        } else if (isNeedRemoveBeanIfKeyChange) {
            this.unregisterBean(beanName);
            this.refreshBeanDependChangeBean(conditionalClass);
            return true;
        }
        return false;
    }

    public void registerBean(String beanName, Class beanClass) {
        log.info("registerBean->beanName:{},beanClass:{}", (Object)beanName, (Object)beanClass);
        BeanDefinitionBuilder beanDefinitionBurinilder = BeanDefinitionBuilder.genericBeanDefinition((Class)beanClass);
        AbstractBeanDefinition beanDefinition = beanDefinitionBurinilder.getBeanDefinition();
        this.setBeanField(beanClass, (BeanDefinition)beanDefinition);
        this.getBeanDefinitionRegistry().registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        this.refreshBeanDependChangeBean(beanClass);
    }

    private void setBeanField(Class beanClass, BeanDefinition beanDefinition) {
        ConfigurationProperties configurationProperties = beanClass.getAnnotation(ConfigurationProperties.class);
        if (!LangUtils.isEmpty((Object)configurationProperties)) {
            String prefix = configurationProperties.prefix();
            for (String propertyName : this.config.getPropertyNames()) {
                String fieldPrefix;
                if (!propertyName.startsWith(fieldPrefix = prefix + ".")) continue;
                String fieldName = propertyName.substring(fieldPrefix.length());
                String fieldVal = this.config.getProperty(propertyName, null);
                log.info("setBeanField-->fieldName:{},fieldVal:{}", (Object)fieldName, (Object)fieldVal);
                beanDefinition.getPropertyValues().add(fieldName, (Object)fieldVal);
            }
        }
    }

    public void unregisterBean(String beanName) {
        log.info("unregisterBean->beanName:{}", (Object)beanName);
        this.getBeanDefinitionRegistry().removeBeanDefinition(beanName);
    }

    public boolean isExistBean(String beanName) {
        return this.applicationContext.containsBean(beanName);
    }

    public boolean isNeedRegisterBeanIfKeyChange(String changeKey, String conditionalOnPropertyValue) {
        if (StringUtils.isEmpty((Object)changeKey)) {
            return false;
        }
        String apolloConfigValue = this.config.getProperty(changeKey, null);
        return conditionalOnPropertyValue.equals(apolloConfigValue);
    }

    private boolean isNeedRemoveBeanIfKeyChange(String changeKey, String conditionalOnPropertyValue) {
        if (!StringUtils.isEmpty((Object)changeKey)) {
            String apolloConfigValue = this.config.getProperty(changeKey, null);
            return !conditionalOnPropertyValue.equals(apolloConfigValue);
        }
        return false;
    }

    private void refreshBeanDependChangeBean(Class conditionalClass) {
        this.beanCache.getRefreshBeanClassesMap().forEach((refreshBeanName, refreshBeanClass) -> {
            RefreshBean refreshBean = refreshBeanClass.getAnnotation(RefreshBean.class);
            for (Class fieldBeanClass : refreshBean.refreshFieldBeans()) {
                if (!conditionalClass.getName().equals(fieldBeanClass.getName())) continue;
                log.info("refreshBeanDependChangeBean-->refreshBeanName:{},refreshBeanClass:{}", refreshBeanName, refreshBeanClass);
                BeanDefinition beanDefinition = this.getBeanDefinitionRegistry().getBeanDefinition(refreshBeanName);
                beanDefinition.setBeanClassName(refreshBeanClass.getName());
                this.getBeanDefinitionRegistry().registerBeanDefinition(refreshBeanName, beanDefinition);
            }
        });
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry() {
        ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)this.applicationContext;
        DefaultListableBeanFactory beanDefinitionRegistry = (DefaultListableBeanFactory)configurableContext.getBeanFactory();
        return beanDefinitionRegistry;
    }
}

