/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.config.refresh;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.sinosoftgz.starter.config.properties.InsConfigProperties;
import com.sinosoftgz.starter.config.utils.LogChangeKeyUtils;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.stereotype.Component;

@Component
public class ConfigPropertiesRefreshConfig {
    private static final Logger log = LoggerFactory.getLogger(ConfigPropertiesRefreshConfig.class);
    private static final String LOG_TITLE = "\u57fa\u4e8eRefreshScope\u5b9e\u73b0\u5237\u65b0";
    private final RefreshScope refreshScope;
    private final InsConfigProperties insConfigProperties;

    public ConfigPropertiesRefreshConfig(InsConfigProperties insConfigProperties, RefreshScope refreshScope) {
        this.insConfigProperties = insConfigProperties;
        this.refreshScope = refreshScope;
    }

    @ApolloConfigChangeListener
    public void onChange(ConfigChangeEvent changeEvent) {
        log.info("\u57fa\u4e8eRefreshScope\u5b9e\u73b0\u5237\u65b0 The to refresh bean name is {}. ", (Object)this.insConfigProperties.getToRefreshBeanNames());
        Optional<String[]> beanArrayOptional = this.insConfigProperties.toRefreshBeanNameArray();
        if (beanArrayOptional.isPresent()) {
            Arrays.stream((Object[])beanArrayOptional.get()).forEach(beanName -> this.refreshScope.refresh((String)beanName));
            LogChangeKeyUtils.printChange(LOG_TITLE, this.insConfigProperties.isEnabledLog(), changeEvent);
        }
    }
}

