/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.config.utils;

import com.sinosoftgz.starter.config.utils.ArraysUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class ClassScannerUtils
implements ResourceLoaderAware {
    private final List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private final List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    public static Set<Class> scan(String[] basePackages, Class<? extends Annotation> ... annotations) {
        ClassScannerUtils cs = new ClassScannerUtils();
        if (!ArraysUtils.isNotEmpty(annotations)) {
            for (Class<? extends Annotation> anno : annotations) {
                cs.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(anno));
            }
        }
        HashSet<Class> classes = new HashSet<Class>();
        for (String s : basePackages) {
            classes.addAll(cs.doScan(s));
        }
        return classes;
    }

    public static Set<Class> scan(String basePackages, Class<? extends Annotation> ... annotations) {
        return ClassScannerUtils.scan(StringUtils.tokenizeToStringArray((String)basePackages, (String)",; \t\n"), annotations);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        this.includeFilters.add(includeFilter);
    }

    public Set<Class> doScan(String basePackage) {
        HashSet<Class> classes = new HashSet<Class>();
        try {
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage)) + "/**/*.class";
            Resource[] resources = this.resourcePatternResolver.getResources(packageSearchPath);
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                if ((this.includeFilters.size() != 0 || this.excludeFilters.size() != 0) && !this.matches(metadataReader)) continue;
                try {
                    classes.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
        return classes;
    }

    protected boolean matches(MetadataReader metadataReader) throws IOException {
        for (TypeFilter tf : this.excludeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return false;
        }
        for (TypeFilter tf : this.includeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }
}

