/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.exception.handler;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.global.common.response.enums.CommonResponseCodeEnum;
import com.sinosoftgz.starter.exception.biz.ArgumentNotValidException;
import com.sinosoftgz.starter.exception.biz.BusinessException;
import com.sinosoftgz.starter.utils.lang.Lang;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ResponseBody
public class WebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(WebExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public BaseResponse unknownException(Exception e) {
        log.error("\u53d1\u751f\u4e86\u672a\u77e5\u5f02\u5e38", (Throwable)e);
        if (e instanceof NoHandlerFoundException) {
            return BaseResponse.notFind((String)("\u672a\u627e\u5230\u9875\u9762: " + e.getMessage()));
        }
        return BaseResponse.error((String)CommonResponseCodeEnum.UNKNOWN_ERROR.getResultCode(), (String)CommonResponseCodeEnum.UNKNOWN_ERROR.getResultMsg());
    }

    @ExceptionHandler(value={BusinessException.class})
    public BaseResponse bizExceptionHandler(BusinessException e) {
        log.error("\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff01\u539f\u56e0\u662f\uff1a{}", (Object)e.getErrorMsg());
        return BaseResponse.error((String)e.getErrorCode(), (String)e.getErrorMsg());
    }

    @ExceptionHandler(value={NullPointerException.class})
    public BaseResponse nullPointerExceptionHandler(NullPointerException e) {
        log.error("\u53d1\u751f\u7a7a\u6307\u9488\u5f02\u5e38\uff01\u539f\u56e0\u662f:", (Throwable)e);
        return BaseResponse.error((String)CommonResponseCodeEnum.BAD_REQUEST.getResultCode(), (String)CommonResponseCodeEnum.BAD_REQUEST.getResultMsg());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public BaseResponse validationBodyException(MethodArgumentNotValidException exception) {
        log.error("\u53d1\u751f\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff01\u539f\u56e0\u662f:", (Throwable)exception);
        return BaseResponse.error((String)CommonResponseCodeEnum.PARAMS_VALIDATION_EMTITY.getResultCode(), (String)exception.getMessage());
    }

    @ExceptionHandler(value={ArgumentNotValidException.class})
    public BaseResponse validationBodyException(ArgumentNotValidException exception) {
        log.error("\u53d1\u751f\u81ea\u5b9a\u4e49\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff01\u539f\u56e0\u662f:", (Throwable)exception);
        return BaseResponse.error((String)CommonResponseCodeEnum.PARAMS_VALIDATION_EMTITY.getResultCode(), (String)exception.getMessage());
    }

    @ExceptionHandler(value={RpcException.class})
    public BaseResponse rpcException(RpcException exception) {
        log.error("\u53d1\u751fRPC\u8c03\u7528\u5f02\u5e38\uff01\u539f\u56e0\u662f:", (Throwable)exception);
        return BaseResponse.error((String)CommonResponseCodeEnum.RPC_CALL_ERROR.getResultCode(), (String)CommonResponseCodeEnum.RPC_CALL_ERROR.getResultMsg());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public BaseResponse rpcException(IllegalArgumentException exception) {
        log.error("\u53c2\u6570\u4e0d\u5408\u6cd5\u5f02\u5e38\uff01\u539f\u56e0\u662f:", (Throwable)exception);
        String message = CommonResponseCodeEnum.PARAMS_VALIDATION_EMTITY.getResultMsg();
        if (!Lang.isEmpty((Object)exception.getLocalizedMessage())) {
            message = exception.getLocalizedMessage();
        }
        return BaseResponse.error((String)CommonResponseCodeEnum.PARAMS_VALIDATION_EMTITY.getResultCode(), (String)message);
    }
}

