package com.sinosoftgz.starter.exception.aspect;

import com.sinosoftgz.starter.exception.biz.ArgumentNotValidException;
import com.sinosoftgz.starter.utils.lang.Lang;
import com.sinosoftgz.starter.validation.utils.ValidationUtils;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;

import java.util.Arrays;
import java.util.List;

/**
 * Created by Roney on 2021/5/18 13:51.
 */
@Slf4j
public abstract class BaseParameterVerifyAspect {


    /**
     * 不要放入配置中心，避免重构的时候，重构不到
     */
    private final String ADD_POINT_CUT
            = " ";


    @Pointcut(ADD_POINT_CUT)
    public void parameterVerifyPointCut() {

    }

    @Around("parameterVerifyPointCut()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        log.debug("参数校验");
        Object[] objs = joinPoint.getArgs();
        List<Object> objectList = Arrays.asList(objs);

        objectList.parallelStream().forEach(obj -> {
            if (!Lang.isEmpty(obj)) {
                ValidationUtils.ValidResult validResult = ValidationUtils.validateBean(obj);
                if (validResult.hasErrors()) {
                    throw new ArgumentNotValidException(validResult.getErrors());
                }
            }
        });

        return joinPoint.proceed(joinPoint.getArgs());

    }


}
