/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.log.aoplog.constant;

import com.sinosoftgz.starter.utils.web.WebUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AopLogConfig {
    private static final Logger log = LoggerFactory.getLogger(AopLogConfig.class);
    private static final String BUNDLE_NAME = "logAop";
    public static final String GLOBAL_TRACEID = "global-trace-id";
    public static final String PARENT_TRACEID = "parent-trace-id";
    public static final String DOMAIN = System.getProperty("weblogic.Name");
    private String ip;
    private int port;
    private String ipAndDomain;
    private static final AopLogConfig aopLogConfig = new AopLogConfig();

    private AopLogConfig() {
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        if (DOMAIN != null) {
            this.ipAndDomain = this.ip + ":" + DOMAIN;
        } else {
            InetAddress addr = WebUtils.getLocalAddress();
            if (addr != null) {
                this.ipAndDomain = addr.toString();
            }
        }
    }

    public static AopLogConfig getInstance() {
        return aopLogConfig;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAndDomain() {
        return this.ipAndDomain;
    }
}

