/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.log.aoplog.filter;

import com.sinosoftgz.starter.log.aoplog.constant.AopLogConfig;
import com.sinosoftgz.starter.log.aoplog.constant.AopThreadLocal;
import com.sinosoftgz.starter.log.aoplog.model.ReqModel;
import com.sinosoftgz.starter.log.aoplog.properties.AopLogProperties;
import com.sinosoftgz.starter.utils.date.DateUtils;
import com.sinosoftgz.starter.utils.lang.Lang;
import com.sinosoftgz.starter.utils.web.WebUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.safehaus.uuid.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class WebAopFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"AOPLOG");
    private static Map<String, String> threadData = new ConcurrentHashMap<String, String>();
    private static Map<String, Integer> threadNum = new ConcurrentHashMap<String, Integer>();
    private static PathMatcher matcher = new AntPathMatcher();
    @Autowired
    AopLogProperties aopLogProperties;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String url = request.getRequestURI();
        if (this.checkUrl(url, this.aopLogProperties.getExcludeUrls()) || this.checkUrl(url, this.aopLogProperties.getExcludeUrlsExts())) {
            chain.doFilter(req, res);
        } else {
            if (AopLogConfig.getInstance().getPort() == 0) {
                AopLogConfig.getInstance().setPort(request.getLocalPort());
            }
            AopLogConfig.getInstance().setIp(WebUtils.getIp((HttpServletRequest)request));
            WebAopFilter.setTraceId(request);
            String userCode = "";
            ReqModel model = new ReqModel(userCode, req.getRemoteAddr(), request.getRequestURI());
            AopThreadLocal.setThreadLocalRequest(model);
            AopThreadLocal.setClientId(WebUtils.getIp((HttpServletRequest)request));
            WebAopFilter.beforeThreadNum();
            String startDate = DateUtils.now((String)"yyyy-MM-dd HH:mm:ss,SSS");
            long startTime = System.currentTimeMillis();
            chain.doFilter(req, res);
            long endTime = System.currentTimeMillis();
            long times = endTime - startTime;
            String requestUrl = "" + request.getRequestURL();
            if (request.getQueryString() != null) {
                requestUrl = request.getRequestURL() + request.getQueryString();
            }
            LOG.info("[{}] [{}] [{}] [{}] [] [{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{WebAopFilter.getServiceId(), WebAopFilter.getMethodId(), WebAopFilter.getLoginUser(), requestUrl, times, startDate, AopThreadLocal.getClientId(), AopThreadLocal.getGlobalTraceId(), AopThreadLocal.getParentTraceId(), AopThreadLocal.getLocalTraceId()});
            WebAopFilter.afterThreadNum();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)filterConfig.getServletContext());
    }

    private static void beforeThreadNum() {
        String threadId = WebAopFilter.getThreadId();
        if (threadNum.get(threadId) == null) {
            threadNum.put(threadId, 1);
        } else {
            threadNum.put(threadId, threadNum.get(threadId) + 1);
        }
        threadData.put(threadId + "|" + threadNum.get(threadId), WebAopFilter.getUuid());
    }

    private static void afterThreadNum() {
        String threadId = WebAopFilter.getThreadId();
        threadData.remove(threadId + "|" + threadNum.get(threadId));
        Integer itg = threadNum.get(threadId);
        if (itg != null) {
            int num = itg;
            if (num == 1) {
                threadNum.remove(threadId);
                AopThreadLocal.setAopServiceId(null);
            } else {
                threadNum.put(threadId, threadNum.get(threadId) - 1);
            }
        }
    }

    private static String getMethodId() {
        String threadId = WebAopFilter.getThreadId();
        return threadData.get(threadId + "|" + threadNum.get(threadId));
    }

    public static String getLoginUser() {
        if (AopThreadLocal.getThreadLocalRequest() != null) {
            return AopThreadLocal.getThreadLocalRequest().getUser();
        }
        return null;
    }

    private static String getThreadId() {
        return String.valueOf(Thread.currentThread().getId());
    }

    private static String getServiceId() {
        String serviceID;
        if (AopThreadLocal.getAopServiceId() != null) {
            serviceID = AopThreadLocal.getAopServiceId();
        } else {
            serviceID = WebAopFilter.getUuid();
            AopThreadLocal.setAopServiceId(serviceID);
        }
        return serviceID;
    }

    private static String getUuid() {
        return UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
    }

    private static void setTraceId(HttpServletRequest request) {
        String pParentTraceId = null;
        String pLocalTraceId = null;
        String pGlobalTraceId = request.getHeader("global-trace-id");
        if (pGlobalTraceId == null || "".equals(pGlobalTraceId.trim())) {
            pGlobalTraceId = UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
            pParentTraceId = "0";
            pLocalTraceId = pGlobalTraceId;
        } else {
            pParentTraceId = request.getHeader("parent-trace-id");
            pLocalTraceId = UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
        }
        AopThreadLocal.setGlobalTraceId(pGlobalTraceId);
        AopThreadLocal.setParentTraceId(pParentTraceId);
        AopThreadLocal.setLocalTraceId(pLocalTraceId);
    }

    private boolean checkUrl(String url, String splitUrls) {
        if (!Lang.isEmpty((Object)url) && !Lang.isEmpty((Object)splitUrls)) {
            String[] excludeUrls;
            String lowerCaseNameUrl = url.toLowerCase();
            for (String excludeUrl : excludeUrls = splitUrls.split(",")) {
                if (matcher.match(excludeUrl.toLowerCase(), lowerCaseNameUrl)) {
                    return true;
                }
                if (lowerCaseNameUrl.indexOf(excludeUrl) <= -1) continue;
                return true;
            }
        }
        return false;
    }
}

