/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.log.tracelog.aspect;

import com.sinosoftgz.starter.log.tracelog.domain.TraceData;
import com.sinosoftgz.starter.log.tracelog.holder.TraceLogHolder;
import com.sinosoftgz.starter.log.tracelog.util.TraceLogUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractTraceLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AbstractTraceLogAspect.class);

    public abstract void traceLogPointcut();

    @Around(value="traceLogPointcut()")
    public Object aroundTraceLog(ProceedingJoinPoint pjp) throws Throwable {
        if (TraceLogUtil.isEnable()) {
            TraceData traceData = new TraceData(pjp);
            TraceLogHolder.push(traceData);
            TraceLogHolder.pushId(traceData);
            try {
                Object object = pjp.proceed(pjp.getArgs());
                return object;
            }
            catch (Throwable e) {
                log.warn("{}", e);
                throw e;
            }
            finally {
                traceData.setEndTime(System.currentTimeMillis());
                TraceLogHolder.popId();
            }
        }
        return pjp.proceed(pjp.getArgs());
    }
}

