/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.log.tracelog.filter;

import com.sinosoftgz.starter.log.tracelog.domain.TraceData;
import com.sinosoftgz.starter.log.tracelog.holder.TraceLogHolder;
import com.sinosoftgz.starter.log.tracelog.util.TraceLogUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TraceLogFilter
implements Filter {
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";
    private static final int DEC = 10;
    private boolean enable;
    private int minTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enable) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
            if (request.getAttribute(alreadyFilteredAttributeName) != null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            } else {
                request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
                Enumeration eut = req.getParameterNames();
                HashMap<String, String> reqDataMap = new HashMap<String, String>();
                while (eut.hasMoreElements()) {
                    String name = (String)eut.nextElement();
                    String value = request.getParameter(name);
                    reqDataMap.put(name, value);
                }
                TraceLogHolder.start();
                TraceData traceData = new TraceData(req);
                TraceLogHolder.push(traceData);
                TraceLogHolder.pushId(traceData);
                try {
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    long endTime = System.currentTimeMillis();
                    if (endTime - traceData.getBeginTime() < (long)this.minTime) return;
                    traceData.setEndTime(endTime);
                    TraceLogHolder.popId();
                    TraceLogHolder.log();
                    return;
                }
                finally {
                    request.removeAttribute(alreadyFilteredAttributeName);
                    TraceLogHolder.clear();
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected String getAlreadyFilteredAttributeName() {
        String name = this.getClass().getName();
        return name + ALREADY_FILTERED_SUFFIX;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.enable = Boolean.valueOf(filterConfig.getInitParameter("enable"));
        this.minTime = Integer.parseInt(filterConfig.getInitParameter("minTime"), 10);
        int maxShowParam = Integer.parseInt(filterConfig.getInitParameter("maxShowParam"), 10);
        TraceLogUtil.setEnable(this.enable);
        TraceLogUtil.setMaxShowParam(maxShowParam);
    }

    public void destroy() {
    }
}

