package com.sinosoftgz.starter.log.aoplog.properties;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;


/**
 * Created by Roney on 2019/8/19.
 *
 * @author Roney
 * @date 2019-08-19 11:14
 */
@Component
@ConfigurationProperties(prefix = "aoplog")
@Data
public class AopLogProperties {

    private static final String[] BY_PASS_URLS_SUFFIX = {".js", ".css", ".ico",
            ".png", ".jpg", ".gif"};
    public boolean enabled;
    /**
     * 扫描的包
     */
    public String basePackage;
    /**
     * 不拦截的url
     */
    public String excludeUrls;
    /**
     * 不拦截的url 后缀
     */
    public String excludeUrlsExts = StringUtils.join(BY_PASS_URLS_SUFFIX, ",");


}
