/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.log.aoplog.config;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.log.aoplog.properties.AopLogProperties;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"aoplog.enabled"}, havingValue="true", matchIfMissing=false)
@Component
@Configuration
public class MethodAspectConfig
implements MethodBeforeAdvice,
AfterReturningAdvice,
MethodInterceptor {
    @Autowired
    AopLogProperties aopLogProperties;
    private Logger logger = LoggerFactory.getLogger(MethodAspectConfig.class);

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
    }

    @Bean(value={"defaultPointcutAdvisor"})
    public DefaultPointcutAdvisor createDefaultPointcutAdvisor() {
        DefaultPointcutAdvisor defaultPointcutAdvisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        MethodAspectConfig advices = new MethodAspectConfig();
        pointcut.setExpression(this.aopLogProperties.getBasePackage());
        defaultPointcutAdvisor.setPointcut((Pointcut)pointcut);
        defaultPointcutAdvisor.setAdvice((Advice)advices);
        return defaultPointcutAdvisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object proceed;
        String className = "";
        String methodName = "";
        long time = 0L;
        List<Object> argsList = new ArrayList();
        try {
            time = System.currentTimeMillis();
            className = invocation.getThis().getClass().getName();
            methodName = invocation.getMethod().getName();
            Object[] args = invocation.getArguments();
            argsList = Arrays.asList(args);
        }
        catch (Exception e) {
            try {
                this.logger.error("[AOP-LOG]\u76d1\u63a7\u7c7b\u540d\u79f0.\u65b9\u6cd5\u540d\u79f0\u4e3a:{}.{},\u8c03\u7528\u5f02\u5e38", new Object[]{className, methodName, e});
            }
            catch (Throwable throwable) {
                Object proceed2 = invocation.proceed();
                this.logger.info("[AOP-LOG]\u76d1\u63a7\u7c7b\u540d\u79f0.\u65b9\u6cd5\u540d\u79f0(\u8bf7\u6c42\u53c2\u6570)\u4e3a:{}.{}({}),\u65b9\u6cd5\u8fd4\u56de\u503c\u662f{},\u8c03\u7528\u8017\u65f6:{}ms", new Object[]{className, methodName, JSON.toJSONString(argsList), JSON.toJSONString((Object)proceed2), System.currentTimeMillis() - time});
                throw throwable;
            }
            proceed = invocation.proceed();
            this.logger.info("[AOP-LOG]\u76d1\u63a7\u7c7b\u540d\u79f0.\u65b9\u6cd5\u540d\u79f0(\u8bf7\u6c42\u53c2\u6570)\u4e3a:{}.{}({}),\u65b9\u6cd5\u8fd4\u56de\u503c\u662f{},\u8c03\u7528\u8017\u65f6:{}ms", new Object[]{className, methodName, JSON.toJSONString(argsList), JSON.toJSONString((Object)proceed), System.currentTimeMillis() - time});
        }
        proceed = invocation.proceed();
        this.logger.info("[AOP-LOG]\u76d1\u63a7\u7c7b\u540d\u79f0.\u65b9\u6cd5\u540d\u79f0(\u8bf7\u6c42\u53c2\u6570)\u4e3a:{}.{}({}),\u65b9\u6cd5\u8fd4\u56de\u503c\u662f{},\u8c03\u7528\u8017\u65f6:{}ms", new Object[]{className, methodName, JSON.toJSONString(argsList), JSON.toJSONString((Object)proceed), System.currentTimeMillis() - time});
        return proceed;
    }
}

