/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.log.logging;

import java.util.Properties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class ComponentLoggingApplicationListener
extends LoggingApplicationListener {
    public static final String APP_NAME_PROPERTY = "logging.appName";
    public static final String APP_NAME = "APP_NAME";

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ConfigurableEnvironment environment = ((ApplicationEnvironmentPreparedEvent)event).getEnvironment();
            this.setAppName(environment);
        }
        super.onApplicationEvent(event);
    }

    private void setAppName(ConfigurableEnvironment environment) {
        String appName = StringUtils.trimWhitespace((String)environment.getProperty(APP_NAME_PROPERTY));
        if (!StringUtils.hasLength((String)appName)) {
            appName = "spring-boot-app";
        }
        Properties properties = System.getProperties();
        properties.put(APP_NAME, appName);
    }
}

