/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mapstruct.common;

import com.sinosoftgz.global.common.response.page.ResultPage;
import java.util.List;
import java.util.stream.Stream;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.MapperConfig;
import org.mapstruct.MappingTarget;
import org.springframework.data.domain.Page;

@MapperConfig
public interface BaseMapping<SOURCE, TARGET> {
    public TARGET sourceToTarget(SOURCE var1);

    public SOURCE targetToSource(TARGET var1);

    @InheritConfiguration(name="sourceToTarget")
    public List<TARGET> sourceToTarget(List<SOURCE> var1);

    @InheritConfiguration(name="targetToSource")
    public List<SOURCE> targetToSource(List<TARGET> var1);

    public List<TARGET> sourceToTarget(Stream<SOURCE> var1);

    public List<SOURCE> targetToSource(Stream<TARGET> var1);

    public void sourceToTarget(SOURCE var1, @MappingTarget TARGET var2);

    public void targetToSource(TARGET var1, @MappingTarget SOURCE var2);

    default public ResultPage<TARGET> mapPage(Page<SOURCE> page) {
        ResultPage resultPage = new ResultPage();
        resultPage.setData(this.sourceToTarget(page.getContent()));
        resultPage.setPerPage((long)page.getSize());
        resultPage.setPageNo((long)page.getNumber());
        resultPage.setTotalCount(page.getTotalElements());
        resultPage.setTotalPage((long)page.getTotalPages());
        return resultPage;
    }

    default public ResultPage<TARGET> sourceToTarget(ResultPage<SOURCE> resultPage) {
        ResultPage resultPageResult = new ResultPage();
        resultPageResult.setData(this.sourceToTarget(resultPage.getData()));
        resultPageResult.setPerPage(resultPage.getPerPage());
        resultPageResult.setPageNo(resultPage.getPageNo());
        resultPageResult.setTotalCount(resultPage.getTotalCount());
        resultPageResult.setTotalPage(resultPage.getTotalPage());
        return resultPageResult;
    }

    default public ResultPage<TARGET> targetToSource(ResultPage<SOURCE> resultPage) {
        ResultPage resultPageResult = new ResultPage();
        resultPageResult.setData(this.sourceToTarget(resultPage.getData()));
        resultPageResult.setPerPage(resultPage.getPerPage());
        resultPageResult.setPageNo(resultPage.getPageNo());
        resultPageResult.setTotalCount(resultPage.getTotalCount());
        resultPageResult.setTotalPage(resultPage.getTotalPage());
        return resultPageResult;
    }
}

