package com.sinosoftgz.starter.mapstruct.common;

import com.sinosoftgz.global.common.response.page.ResultPage;
import org.mapstruct.*;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.stream.Stream;

/**
 * Created by Roney on 2020/12/2 14:17.
 * <p>
 * mapstruct  BaseMapping
 */
@MapperConfig
public interface BaseMapping<SOURCE, TARGET> {

    /**
     * 映射同名属性
     *
     * @param var1
     * @return
     */
    TARGET sourceToTarget(SOURCE var1);

    /**
     * 反向，映射同名属性
     *
     * @param var1
     * @return
     */
    SOURCE targetToSource(TARGET var1);

    /**
     * 映射同名属性，集合形式
     *
     * @param var1
     * @return
     */
    @InheritConfiguration(name = "sourceToTarget")
    List<TARGET> sourceToTarget(List<SOURCE> var1);

    /**
     * 反向，映射同名属性，集合形式
     *
     * @param var1
     * @return
     */
    @InheritConfiguration(name = "targetToSource")
    List<SOURCE> targetToSource(List<TARGET> var1);

    /**
     * 映射同名属性，集合流形式
     *
     * @param stream
     * @return
     */
    List<TARGET> sourceToTarget(Stream<SOURCE> stream);

    /**
     * 反向，映射同名属性，集合流形式
     *
     * @param stream
     * @return
     */
    List<SOURCE> targetToSource(Stream<TARGET> stream);


    /**
     * 不创建对象从source拷贝对象到target
     *
     * @param var1
     * @param var2
     */
    void sourceToTarget(SOURCE var1, @MappingTarget TARGET var2);


    /**
     * 不创建对象从target拷贝对象到source
     *
     * @param var1
     * @param var2
     */
    void targetToSource(TARGET var1, @MappingTarget SOURCE var2);


    /**
     * 基于JPA分页查询，ResultPage对象
     *
     * @param page
     * @return
     */
    default ResultPage<TARGET> mapPage(Page<SOURCE> page) {
        ResultPage<TARGET> resultPage = new ResultPage<>();
        resultPage.setData(this.sourceToTarget(page.getContent()));
        resultPage.setPerPage(page.getSize());
        resultPage.setPageNo(page.getNumber());
        resultPage.setTotalCount(page.getTotalElements());
        resultPage.setTotalPage(page.getTotalPages());
        return resultPage;
    }

    /**
     * 基于ResultPage分页查询，ResultPage对象
     *
     * @param resultPage
     * @return
     */
    default ResultPage<TARGET> sourceToTarget(ResultPage<SOURCE> resultPage) {
        ResultPage<TARGET> resultPageResult = generatorResultPageTarget((ResultPage<SOURCE>) resultPage);
        resultPageResult.setData(this.sourceToTarget(resultPage.getData()));
        return resultPageResult;
    }

    /**
     * 基于ResultPage分页查询，ResultPage对象
     *
     * @param resultPage
     * @return
     */
    default ResultPage<TARGET> targetToSource(ResultPage<SOURCE> resultPage) {
        ResultPage<TARGET> resultPageResult = generatorResultPageTarget(resultPage);
        resultPageResult.setData(this.sourceToTarget(resultPage.getData()));
        return resultPageResult;
    }

    /**
     * generatorResultPageTarget
     *
     * @param resultPage
     * @return
     */
    default ResultPage<TARGET> generatorResultPageTarget(ResultPage<SOURCE> resultPage) {
        ResultPage<TARGET> resultPageResult = new ResultPage<>();
        resultPageResult.setPerPage(resultPage.getPerPage());
        resultPageResult.setPageNo(resultPage.getPageNo());
        resultPageResult.setTotalCount(resultPage.getTotalCount());
        resultPageResult.setTotalPage(resultPage.getTotalPage());
        return resultPageResult;
    }
}
