/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.open.api.config;

import com.sinosoftgz.starter.open.api.properties.OpenApiProperties;
import java.util.Arrays;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

@Configuration
@Import(value={})
@EnableConfigurationProperties(value={OpenApiProperties.class})
@ConditionalOnProperty(prefix="open.api", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(name={"org.tuckey.web.filters.urlrewrite.UrlRewriteFilter"})
public class OpenApiConfiguration {
    @Autowired
    OpenApiProperties openApiProperties;

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(0);
        filterRegistrationBean.setEnabled(true);
        UrlRewriteFilter urlRewriteFilter = new UrlRewriteFilter();
        filterRegistrationBean.setFilter((Filter)urlRewriteFilter);
        filterRegistrationBean.setUrlPatterns(Arrays.asList(this.openApiProperties.getUrls()));
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD});
        if (this.openApiProperties.getInitParameter() != null && this.openApiProperties.getInitParameter().size() > 0) {
            for (String key : this.openApiProperties.getInitParameter().keySet()) {
                filterRegistrationBean.addInitParameter(key, this.openApiProperties.getInitParameter().get(key));
            }
        }
        return filterRegistrationBean;
    }
}

