package com.sinosoftgz.starter.open.api.config;

import com.sinosoftgz.starter.open.api.properties.OpenApiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

import javax.servlet.DispatcherType;
import java.util.Arrays;

/**
 * @author: Roney
 * @date: 2021-10-15 11:21
 * @description: OpenApiConfiguration
 */

@Configuration
@Import({

})
@EnableConfigurationProperties({OpenApiProperties.class})
@ConditionalOnProperty(prefix = OpenApiProperties.OPEN_API_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@ConditionalOnClass(name = {"org.tuckey.web.filters.urlrewrite.UrlRewriteFilter"})
public class OpenApiConfiguration {

    @Autowired
    OpenApiProperties openApiProperties;

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(0);
        filterRegistrationBean.setEnabled(true);

        UrlRewriteFilter urlRewriteFilter = new UrlRewriteFilter();

        filterRegistrationBean.setFilter(urlRewriteFilter);
        filterRegistrationBean.setUrlPatterns(Arrays.asList(openApiProperties.getUrls()));
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, DispatcherType.FORWARD);
        if (openApiProperties.getInitParameter() != null && openApiProperties.getInitParameter().size() > 0) {
            for (String key : openApiProperties.getInitParameter().keySet()) {
                filterRegistrationBean.addInitParameter(key, openApiProperties.getInitParameter().get(key));
            }
        }

        return filterRegistrationBean;
    }
}
