package com.sinosoftgz.starter.open.api.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;


@ConfigurationProperties(prefix = OpenApiProperties.OPEN_API_PREFIX)
@Data
public class OpenApiProperties implements Serializable {

    public static final String OPEN_API_PREFIX = "open.api";

    public OpenApiProperties() {
        initParameter.put("confPath", "api/apiConfig.xml");
        initParameter.put("statusPath", "/_api/_status");
        initParameter.put("statusEnabled", "true");
        initParameter.put("logLevel", "INFO");
    }


    /**
     * 是否开启
     * 默认开启
     */
    private boolean enabled = true;

    String[] urls = {"/_api/*"};

    Map<String, String> initParameter = new HashMap<>();
}
