package com.sinosoftgz.starter.sequence.config;

import com.sinosoftgz.starter.sequence.utils.SequenceUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;


/**
 * Created by Roney on 2019/5/8 16:43
 *
 * @author Roney
 */
@Configuration
public class SequenceConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SequenceUtils sequenceUtils(JdbcTemplate jdbcTemplate, RedisTemplate redisTemplate) {
        return new SequenceUtils(redisTemplate, jdbcTemplate);
    }
}
