/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.sequence.utils;

import com.sinosoftgz.starter.utils.concurrent.ThreadPoolUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.exceptions.JedisDataException;

@Component
@ConfigurationProperties(prefix="sequence")
public class SequenceUtils
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SequenceUtils.class);
    private static Map<String, String> createSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> insertSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> querySequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> queryMaxSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> queryGroupSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> updateSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> deleteSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> dropSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private final String ORDERNO_REDIS_KEY = "mall:sequenceNo";
    private Long maxCycle = 1000000L;
    private ExecutorService executorService = null;
    private RedisTemplate redisTemplate;
    private JdbcTemplate jdbcTemplate;
    private final String SEPARATOR = ":";
    private String databaseType;
    private String tableName;
    private String CREATE_SEQUECENCE_TABLE_SQL = null;
    private String INIT_SEQUECENCE_TABLE_SQL = null;
    private String QUERY_SEQUECENCE_TABLE_SQL = null;
    private String QUERY_MAX_SEQUECENCE_TABLE_SQL = null;
    private String QUERY_GROUP_SEQUECENCE_TABLE_SQL = null;
    private String UPDATE_SEQUECENCE_TABLE_SQL = null;
    private String DELETE_SEQUECENCE_TABLE_SQL = null;
    private String DROP_SEQUECENCE_TABLE_SQL = null;

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SequenceUtils(RedisTemplate redisTemplate, JdbcTemplate jdbcTemplate) {
        this.redisTemplate = redisTemplate;
        this.jdbcTemplate = jdbcTemplate;
    }

    public String generateSequence(String sequenceKey) {
        return this.generateSequence(sequenceKey, 8, 0L, "");
    }

    public String generateSequence(String sequenceKey, String prefix) {
        return this.generateSequence(sequenceKey, 8, prefix);
    }

    public String generateSequence(String key, int length, String prefix) {
        return this.generateSequence(key, length, 0L, prefix);
    }

    public String getRequestId(String pre) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTime = dateFormat.format(new Date());
        String redisKey = "mall:sequenceNo:REQUESTID:" + pre + ":" + dateTime;
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)redisKey);
        Long next = operations.increment(1L);
        if (next == 1L) {
            operations.expire(10L, TimeUnit.MINUTES);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(pre).append(dateTime);
        long i = next;
        while (i * 10L < this.maxCycle) {
            builder.append(0);
            i *= 10L;
        }
        builder.append(next);
        return builder.toString();
    }

    private String generateSequence(final String sequenceKey, int length, long start, String prefix) {
        int t;
        if (ObjectUtils.isEmpty((Object)sequenceKey)) {
            throw new RuntimeException("\u5e8f\u5217\u53f7key\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if ((long)length <= start) {
            log.error("\u957f\u5ea6\u5c0f\u4e8e\u5f00\u59cb\u503c\uff0c\u5e8f\u5217\u53f7\u751f\u6210\u5931\u8d25!length\uff1a{},start:{}", (Object)length, (Object)start);
            throw new RuntimeException("\u957f\u5ea6\u5c0f\u4e8e\u5f00\u59cb\u503c\uff0c\u5e8f\u5217\u53f7\u751f\u6210\u5931\u8d25!");
        }
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("mall:sequenceNo:" + sequenceKey));
        if (boundValueOperations.get() == null) {
            BoundValueOperations sequenceTableLockOperations = this.redisTemplate.boundValueOps((Object)("mall:sequenceNo:TABLE:LOCK:" + sequenceKey));
            if (!sequenceTableLockOperations.setIfAbsent((Object)true).booleanValue()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    log.error("InterruptedException:", (Throwable)e);
                }
                sequenceTableLockOperations.expire(10L, TimeUnit.SECONDS);
                return this.generateSequence(sequenceKey, length, start, prefix);
            }
            SqlRowSet existSequenceRowSet = this.jdbcTemplate.queryForRowSet(this.QUERY_SEQUECENCE_TABLE_SQL, new Object[]{sequenceKey});
            Long existSequence = 0L;
            if (existSequenceRowSet.next()) {
                existSequence = existSequenceRowSet.getLong(1);
            }
            boundValueOperations.set((Object)existSequence);
        }
        long startTime = System.currentTimeMillis();
        String sequence = null;
        Exception exception = null;
        for (t = 0; t < 5; ++t) {
            try {
                final Long increment = boundValueOperations.increment(1L);
                if (increment >= this.maxCycle) {
                    BoundValueOperations sequenceLockOperations = this.redisTemplate.boundValueOps((Object)("mall:sequenceNoCIRCULATE:LOCK:" + sequenceKey));
                    if (sequenceLockOperations.setIfAbsent((Object)true).booleanValue()) {
                        boundValueOperations.set((Object)start);
                        sequenceLockOperations.expire(300L, TimeUnit.MICROSECONDS);
                        return this.generateSequence(sequenceKey, length, start, prefix);
                    }
                    Thread.sleep(200L);
                    return this.generateSequence(sequenceKey, length, start, prefix);
                }
                sequence = prefix + this.fillLeftZero(increment, length);
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        List lastSequenceList = SequenceUtils.this.jdbcTemplate.queryForList(SequenceUtils.this.QUERY_SEQUECENCE_TABLE_SQL, new Object[]{sequenceKey});
                        if (CollectionUtils.isEmpty((Collection)lastSequenceList)) {
                            BoundValueOperations initDbSequenceLockOperations = SequenceUtils.this.redisTemplate.boundValueOps((Object)("mall:sequenceNo:INIT:LOCK:" + sequenceKey));
                            if (initDbSequenceLockOperations.setIfAbsent((Object)true).booleanValue()) {
                                initDbSequenceLockOperations.expire(1L, TimeUnit.MINUTES);
                                SequenceUtils.this.jdbcTemplate.update(SequenceUtils.this.INIT_SEQUECENCE_TABLE_SQL, new Object[]{sequenceKey, increment});
                            } else {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    log.error("InterruptedException:", (Throwable)e);
                                }
                                SequenceUtils.this.updateSequence(increment, sequenceKey);
                            }
                        } else {
                            SequenceUtils.this.updateSequence(increment, sequenceKey);
                        }
                    }
                });
                break;
            }
            catch (Exception e) {
                if (e instanceof JedisDataException) {
                    boundValueOperations.set((Object)0L);
                }
                exception = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
        }
        if (t >= 5) {
            throw new RuntimeException("\u751f\u6210\u5e8f\u5217\u53f7\u5931\u8d25", exception);
        }
        log.debug("\u751f\u6210\u5e8f\u5217\u53f7\u8017\u65f6\uff1a{} ", (Object)(System.currentTimeMillis() - startTime));
        log.info("sequence--->{}", sequence);
        return sequence;
    }

    private String fillLeftZero(Long max, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(max);
        if (sb.length() >= length) {
            return sb.substring(sb.length() - length);
        }
        for (int i = sb.length(); i < length; ++i) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    private void updateSequence(Long increment, String sequenceKey) {
        this.jdbcTemplate.update(this.UPDATE_SEQUECENCE_TABLE_SQL, new Object[]{increment, increment, this.maxCycle - 1L, sequenceKey});
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        List overSequences;
        block6: {
            this.executorService = ThreadPoolUtils.createThreadPool((Integer)3, (String)"\u5e8f\u5217\u53f7\u540c\u6b65");
            log.debug("\u521d\u59cb\u5316sql\u4fe1\u606f\uff0c\u4ee5\u53ca\u8868\u7ed3\u6784");
            if (ObjectUtils.isEmpty((Object)this.databaseType) || ObjectUtils.isEmpty((Object)this.tableName)) {
                throw new RuntimeException("\u6570\u636e\u5e93\u7c7b\u578b\u548c\u8868\u7ed3\u6784\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            this.CREATE_SEQUECENCE_TABLE_SQL = String.format(createSqlMap.get(this.databaseType), this.tableName);
            this.INIT_SEQUECENCE_TABLE_SQL = String.format(insertSqlMap.get(this.databaseType), this.tableName);
            this.QUERY_SEQUECENCE_TABLE_SQL = String.format(querySequenceSqlMap.get(this.databaseType), this.tableName);
            this.QUERY_MAX_SEQUECENCE_TABLE_SQL = String.format(queryMaxSequenceSqlMap.get(this.databaseType), this.tableName);
            this.QUERY_GROUP_SEQUECENCE_TABLE_SQL = String.format(queryGroupSequenceSqlMap.get(this.databaseType), this.tableName);
            this.UPDATE_SEQUECENCE_TABLE_SQL = String.format(updateSequenceSqlMap.get(this.databaseType), this.tableName);
            this.DELETE_SEQUECENCE_TABLE_SQL = String.format(deleteSequenceSqlMap.get(this.databaseType), this.tableName);
            this.DROP_SEQUECENCE_TABLE_SQL = String.format(dropSequenceSqlMap.get(this.databaseType), this.tableName);
            overSequences = null;
            try {
                overSequences = this.jdbcTemplate.queryForList(this.QUERY_GROUP_SEQUECENCE_TABLE_SQL, String.class);
            }
            catch (Exception e) {
                if (!(e instanceof BadSqlGrammarException)) break block6;
                try {
                    this.jdbcTemplate.execute(this.DROP_SEQUECENCE_TABLE_SQL);
                }
                catch (Exception ex) {
                    log.error("Exception:", (Throwable)ex);
                }
                this.jdbcTemplate.execute(this.CREATE_SEQUECENCE_TABLE_SQL);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)overSequences)) {
            overSequences.forEach(sequenceKey -> {
                Long maxSequence = (Long)this.jdbcTemplate.queryForObject(this.QUERY_MAX_SEQUECENCE_TABLE_SQL, Long.class, new Object[]{sequenceKey});
                this.jdbcTemplate.update(this.DELETE_SEQUECENCE_TABLE_SQL, new Object[]{sequenceKey});
                this.jdbcTemplate.update(this.INIT_SEQUECENCE_TABLE_SQL, new Object[]{sequenceKey, maxSequence});
            });
        }
    }

    static {
        createSqlMap.put("h2", "CREATE TABLE %s (sequence_key varchar(255) ,sequence number)");
        createSqlMap.put("mysql", "CREATE TABLE %s (sequence_key varchar(255) ,sequence bigint)");
        createSqlMap.put("informix", "CREATE TABLE %s (sequence_key varchar(255) ,sequence number)");
        createSqlMap.put("oracle", "CREATE TABLE %s (sequence_key varchar(255) ,sequence number)");
        insertSqlMap.put("h2", "insert into %s(sequence_key,sequence) values(?,?)");
        insertSqlMap.put("mysql", "insert into %s(sequence_key,sequence) values(?,?)");
        insertSqlMap.put("informix", "insert into %s(sequence_key,sequence) values(?,?)");
        insertSqlMap.put("oracle", "insert into %s(sequence_key,sequence) values(?,?)");
        querySequenceSqlMap.put("h2", "select sequence from  %s where sequence_key=? ");
        querySequenceSqlMap.put("mysql", "select sequence from  %s where sequence_key=? ");
        querySequenceSqlMap.put("informix", "select sequence from  %s where sequence_key=? ");
        querySequenceSqlMap.put("oracle", "select sequence from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("h2", "select max(sequence) from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("mysql", "select max(sequence) from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("informix", "select max(sequence) from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("oracle", "select max(sequence) from  %s where sequence_key=? ");
        queryGroupSequenceSqlMap.put("h2", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        queryGroupSequenceSqlMap.put("mysql", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        queryGroupSequenceSqlMap.put("informix", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        queryGroupSequenceSqlMap.put("oracle", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        updateSequenceSqlMap.put("h2", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        updateSequenceSqlMap.put("mysql", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        updateSequenceSqlMap.put("informix", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        updateSequenceSqlMap.put("oracle", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        deleteSequenceSqlMap.put("h2", "delete from  %s where sequence_key=? ");
        deleteSequenceSqlMap.put("mysql", "delete from  %s where sequence_key=? ");
        deleteSequenceSqlMap.put("informix", "delete from  %s where sequence_key=? ");
        deleteSequenceSqlMap.put("oracle", "delete from  %s where sequence_key=? ");
        dropSequenceSqlMap.put("h2", "drop table %s ");
        dropSequenceSqlMap.put("mysql", "drop table %s ");
        dropSequenceSqlMap.put("informix", "drop table %s ");
        dropSequenceSqlMap.put("oracle", "drop table %s ");
    }
}

